/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import io.fabric8.kubernetes.api.model.Secret;
import java.util.Optional;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"ssh-credentials"})
public class BasicSSHUserPrivateKeyCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "basicSSHUserPrivateKey".equals(type);
    }

    public BasicSSHUserPrivateKey convert(Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "basicSSHUserPrivateKey definition contains no data");
        String privateKeyBase64 = SecretUtils.getNonNullSecretData(secret, "privateKey", "basicSSHUserPrivateKey credential is missing the privateKey");
        String privateKey = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(privateKeyBase64), "basicSSHUserPrivateKey credential has an invalid privateKey (must be base64 encoded UTF-8)");
        String usernameBase64 = SecretUtils.getNonNullSecretData(secret, "username", "basicSSHUserPrivateKey credential is missing the username");
        String username = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(usernameBase64), "basicSSHUserPrivateKey credential has an invalid username (must be base64 encoded UTF-8)");
        Optional<String> optPassphraseBase64 = SecretUtils.getOptionalSecretData(secret, "passphrase", "basicSSHUserPrivateKey credential: failed to retrieve passphrase, assuming private key has an empty passphrase");
        String passphrase = null;
        if (optPassphraseBase64.isPresent()) {
            passphrase = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(optPassphraseBase64.get()), "basicSSHUserPrivateKey credential has an invalid passphrase (must be base64 encoded UTF-8)");
        }
        return new BasicSSHUserPrivateKey(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), username, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), passphrase, SecretUtils.getCredentialDescription(secret));
    }
}

