/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.Script;
import java.lang.reflect.InvocationTargetException;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ContinuableTest
extends AbstractGroovyCpsTest {
    @Test
    public void resumeAndSuspend() throws Throwable {
        Script s = this.getCsh().parse("int x = 1;\nx = Continuable.suspend(x+1)\nreturn x+1;\n");
        Continuable c = new Continuable(s);
        Assert.assertTrue((boolean)c.isResumable());
        Object v = c.run(null);
        Assert.assertEquals((String)"Continuable.suspend(x+1) returns the control back to us", (Object)2, (Object)v);
        Assert.assertTrue((String)"Continuable is resumable because it has 'return x+1' to execute.", (boolean)c.isResumable());
        Assert.assertEquals((String)"We resume continuable, then the control comes back from the return statement", (Object)4, (Object)c.run((Object)3));
        Assert.assertFalse((String)"We've run the program till the end, so it's no longer resumable", (boolean)c.isResumable());
    }

    @Test
    public void serializeComplexContinuable() throws Throwable {
        Script s = this.getCsh().parse("def foo(int x) {\n    return Continuable.suspend(x);\n}\ndef plus3(int x) {\n    return x+3;\n}\ntry {\n    for (int x=0; x<1; x++) {\n        while (true) {\n            y = plus3(foo(5))\n            break;\n        }\n    }\n} catch (ClassCastException e) {\n    y = e;\n}\nreturn y;\n");
        Continuable c = new Continuable(s);
        Assert.assertEquals((String)"suspension within a subroutine", (Object)5, (Object)c.run(null));
        c = this.roundtripSerialization(c);
        Assert.assertTrue((boolean)c.isResumable());
        Assert.assertEquals((Object)9, (Object)c.run((Object)6));
    }

    @Test
    public void howComeBindingIsSerializable() throws Throwable {
        Script s = this.getCsh().parse("Continuable.suspend(42);\nreturn value;\n");
        s.setProperty("value", (Object)15);
        Continuable c = new Continuable(s);
        Assert.assertEquals((Object)42, (Object)c.run(null));
        c = this.roundtripSerialization(c);
        Assert.assertTrue((boolean)c.isResumable());
        Assert.assertEquals((Object)15, (Object)c.run(null));
    }

    @Test
    public void suspend_at_the_end_should_still_count_as_resumable() throws Throwable {
        Script s = this.getCsh().parse("Continuable.suspend(5);");
        Continuable c = new Continuable(s);
        Assert.assertEquals((Object)5, (Object)c.run(null));
        Assert.assertTrue((boolean)c.isResumable());
        c.run(null);
        Assert.assertFalse((boolean)c.isResumable());
    }

    @Test
    public void unhandled_exception() throws Throwable {
        Script s = this.getCsh().parse("throw new " + ContinuableTest.class.getName() + ".HelloException()");
        Continuable c = new Continuable(s);
        try {
            c.run(null);
            Assert.fail((String)"should have thrown exception");
        }
        catch (InvocationTargetException e) {
            Assert.assertFalse((boolean)c.isResumable());
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(HelloException.class));
        }
    }

    @Test
    public void yieldObjectShouldNotBeInObjectGraph() throws Throwable {
        Script s = this.getCsh().parse("Continuable.suspend(new ContinuableTest.ThisObjectIsNotSerializable());");
        Continuable c = new Continuable(s);
        Object r = c.run(null);
        MatcherAssert.assertThat((Object)r, (Matcher)CoreMatchers.instanceOf(ThisObjectIsNotSerializable.class));
        c = this.roundtripSerialization(c);
        Assert.assertTrue((boolean)c.isResumable());
        Assert.assertEquals((Object)42, (Object)c.run((Object)42));
    }

    @Test
    public void stackTrace() throws Throwable {
        Script s = this.getCsh().parse("def x(i,v) {\n  if (i>0)\n    y(i-1,v);\n  else\n    Continuable.suspend(v);\n}\n\ndef y(i,v) {\n  if (i>0)\n    x(i-1,v);\n  else\n    Continuable.suspend(v);\n}\n\nx(5,3);\n");
        Continuable c = new Continuable(s);
        Assert.assertTrue((boolean)c.getStackTrace().isEmpty());
        Object v = c.run(null);
        Assert.assertEquals((Object)3, (Object)v);
        MatcherAssert.assertThat(c.getStackTrace().stream().map(Object::toString).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"Script1.y(Script1.groovy:12)"), CoreMatchers.containsString((String)"Script1.x(Script1.groovy:3)"), CoreMatchers.containsString((String)"Script1.y(Script1.groovy:10)"), CoreMatchers.containsString((String)"Script1.x(Script1.groovy:3)"), CoreMatchers.containsString((String)"Script1.y(Script1.groovy:10)"), CoreMatchers.containsString((String)"Script1.x(Script1.groovy:3)"), CoreMatchers.containsString((String)"Script1.run(Script1.groovy:15)")}));
        c.run(null);
        Assert.assertTrue((boolean)c.getStackTrace().isEmpty());
    }

    @Test
    public void staticMethod1() throws Throwable {
        Script s = this.getCsh().parse("import static java.lang.Class.forName; forName('java.lang.Integer')");
        Continuable c = new Continuable(s);
        Object r = c.run(null);
        Assert.assertEquals(Integer.class, (Object)r);
    }

    @Test
    public void staticMethod2() throws Throwable {
        Script s = this.getCsh().parse("import static java.lang.Integer.toString; toString(31,16)");
        Continuable c = new Continuable(s);
        Object r = c.run(null);
        Assert.assertEquals((Object)"1f", (Object)r);
    }

    @Test
    public void staticMethod0() throws Throwable {
        Script s = this.getCsh().parse("import static com.cloudbees.groovy.cps.ContinuableTest.StaticMethodHost.methodWithNoArgs; methodWithNoArgs()");
        Continuable c = new Continuable(s);
        Object r = c.run(null);
        Assert.assertEquals((Object)"hello", (Object)r);
    }

    @Test
    public void concatenate() throws Throwable {
        Script s = this.getCsh().parse("def plus2(i) { return i+2; }\ndef i=1;\nx = Continuable.suspend('pause1');\nreturn plus2(i+x);\n");
        Continuable c = new Continuable(s);
        Assert.assertEquals((Object)"pause1", (Object)c.run(null));
        Script s2 = this.getCsh().parse("return 16+Continuable.suspend('pause2')+32;");
        final Continuable pause = c;
        c = new Continuable(s2, null, new Continuation(){

            public Next receive(Object o) {
                return Next.go0((Outcome)new Outcome((Object)((Integer)o + 64), null), (Continuable)pause);
            }
        });
        Assert.assertEquals((Object)"pause2", (Object)c.run(null));
        Object r = c.run((Object)128);
        Assert.assertFalse((boolean)c.isResumable());
        Assert.assertEquals((Object)243, (Object)r);
    }

    public static class HelloException
    extends Exception {
    }

    public static class ThisObjectIsNotSerializable {
    }

    public static class StaticMethodHost {
        public static String methodWithNoArgs() {
            return "hello";
        }
    }
}

