/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.google.gson.JsonObject;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReportTableModel
extends TableModel {
    private List<JsonObject> ja;
    String rptType;

    public ReportTableModel(List<JsonObject> ja, String rptType) {
        this.ja = ja;
        this.rptType = rptType;
    }

    public String getId() {
        return "cfa";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(new TableColumn("Job name", "jobName"));
        if (this.rptType.equals("IMS")) {
            columns.add(new TableColumn("PSB Name", "psbName"));
        } else {
            columns.add(new TableColumn("Plan Name", "planName"));
        }
        columns.add(new TableColumn("Start time", "startTime"));
        if (this.rptType.equals("IMS")) {
            columns.add(new TableColumn("#Checkpoints", "chkpt#"));
        } else {
            columns.add(new TableColumn("#Commits", "commits#"));
        }
        if (this.rptType.equals("IMS")) {
            columns.add(new TableColumn("Checkpoint Type", "chkptType"));
        }
        columns.add(new TableColumn("Job Duration", "jobDuration"));
        columns.add(new TableColumn("Commit per min", "freqPerMin"));
        columns.add(new TableColumn("Commit per sec", "freqPerSec"));
        columns.add(new TableColumn("Exceptions", "exceptions"));
        return columns;
    }

    public List<Object> getRows() {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (JsonObject obj : this.ja) {
            HashMap<String, String> rowsMap = new HashMap<String, String>();
            rowsMap.put("jobName", obj.get("jobName").toString());
            if (this.rptType.equals("IMS")) {
                rowsMap.put("psbName", obj.get("psbName").toString());
            } else {
                rowsMap.put("planName", obj.get("planName").toString());
            }
            rowsMap.put("startTime", obj.get("startTime").toString());
            if (this.rptType.equals("IMS")) {
                rowsMap.put("chkpt#", obj.get("chkpt#").toString());
                rowsMap.put("chkptType", obj.get("chkptType").toString());
            } else {
                rowsMap.put("commits#", obj.get("commits#").toString());
            }
            rowsMap.put("jobDuration", obj.get("jobDuration").toString());
            rowsMap.put("freqPerMin", obj.get("freqPerMin").toString());
            rowsMap.put("freqPerSec", obj.get("freqPerSec").toString());
            rowsMap.put("exceptions", obj.get("exceptions").toString());
            rows.add(rowsMap);
        }
        return rows;
    }
}

