/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.bmc.ims.CsvFile;
import com.bmc.ims.ReportViewModel;
import com.bmc.ims.ResponseObject;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import io.jenkins.plugins.util.AbstractXmlStream;
import io.jenkins.plugins.util.BuildAction;
import io.jenkins.plugins.util.JobAction;
import java.io.File;
import org.kohsuke.stapler.StaplerProxy;

public class BmcCfaAction
extends BuildAction
implements StaplerProxy {
    String ws;
    int buildNum;
    Run owner;
    String reportType;
    String jobid;
    String csvFileName;
    ResponseObject resp;

    public BmcCfaAction(Run owner, int number, String workspace, ResponseObject resp, String jobid, String csvFileName) {
        super(owner, (Object)resp, false);
        this.ws = workspace;
        this.buildNum = number;
        this.owner = owner;
        this.resp = resp;
        this.jobid = jobid;
        this.csvFileName = csvFileName;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Commit Distribution - " + this.jobid + " - " + this.csvFileName;
    }

    public String getUrlName() {
        return "stat" + this.jobid + this.csvFileName;
    }

    public Object getTarget() {
        return new ReportViewModel(this.owner, CsvFile.readCsvFile(this.getRelatedJob().getPath()), this.reportType);
    }

    public File getRelatedJob() {
        File dir = new File(this.ws + File.separator + this.buildNum + File.separator + this.jobid);
        File[] matches = dir.listFiles((dir1, name) -> name.contains(this.csvFileName));
        if (matches == null) {
            return dir;
        }
        this.reportType = matches[0].getPath().contains("IMS") || matches[0].getPath().contains("DLI") ? "IMS" : "DB2";
        return matches[0];
    }

    @CheckForNull
    protected AbstractXmlStream createXmlStream() {
        return null;
    }

    @CheckForNull
    protected JobAction<? extends BuildAction> createProjectAction() {
        return null;
    }

    protected String getBuildResultBaseName() {
        return "cfa" + this.jobid + this.csvFileName;
    }
}

