/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils.report;

import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.blazemeter.PerformanceBuildAction;
import hudson.remoting.VirtualChannel;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportUrlTask
extends TimerTask {
    protected Logger logger = Logger.getLogger(ReportUrlTask.class.getName());
    protected String jobName;
    private VirtualChannel channel;
    private Run run;
    protected boolean isDone;
    protected final long reportLinkId;

    public ReportUrlTask(Run run, String jobName, VirtualChannel channel, long reportLinkId) {
        this.run = run;
        this.jobName = jobName;
        this.channel = channel;
        this.reportLinkId = reportLinkId;
    }

    @Override
    public void run() {
        try {
            if (this.isDone) {
                return;
            }
            EnvVars ev = EnvVars.getRemote((VirtualChannel)this.channel);
            String runId = this.jobName + "-" + this.run.getId() + "-" + this.reportLinkId;
            if (ev != null && ev.containsKey((Object)runId)) {
                String masterId = ev.get(runId, "");
                PerformanceBuildAction a = new PerformanceBuildAction(this.run, masterId);
                a.setReportUrl(ev.get(runId + "-" + masterId, ""));
                a.setLinkName(ev.get(runId + "-link-name", "BlazeMeter Report"));
                this.run.addAction((Action)a);
                this.isDone = true;
                super.cancel();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to get report URL", e);
        }
    }

    public boolean isDone() {
        return this.isDone;
    }
}

