/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.ProxyConfiguration;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class ProxyConfigurator {
    private static final Logger LOGGER = Logger.getLogger(ProxyConfigurator.class.getName());
    static String PROXY_HOST = "http.proxyHost";
    static String PROXY_PORT = "http.proxyPort";
    static String PROXY_USER = "http.proxyUser";
    static String PROXY_PASS = "http.proxyPass";
    static String PROXY_OVERRIDE = "proxy.override";

    public static void updateProxySettings(ProxyConfiguration proxyConfiguration, boolean isSlave) throws Exception {
        if (isSlave && "true".equals(System.getProperty(PROXY_OVERRIDE))) {
            LOGGER.info("Override proxy setting for slave");
            LOGGER.info("Use proxy host: " + System.getProperty(PROXY_HOST));
            LOGGER.info("Use proxy port: " + System.getProperty(PROXY_PORT));
            return;
        }
        if (proxyConfiguration != null) {
            if (StringUtils.isNotBlank((String)proxyConfiguration.name)) {
                LOGGER.info("Use proxy host: " + proxyConfiguration.name);
                System.setProperty(PROXY_HOST, proxyConfiguration.name);
            }
            if (StringUtils.isNotBlank((String)String.valueOf(proxyConfiguration.port))) {
                LOGGER.info("Use proxy port: " + proxyConfiguration.port);
                System.setProperty(PROXY_PORT, String.valueOf(proxyConfiguration.port));
            }
            if (StringUtils.isNotBlank((String)proxyConfiguration.getUserName())) {
                System.setProperty(PROXY_USER, proxyConfiguration.getUserName());
            }
            if (StringUtils.isNotBlank((String)proxyConfiguration.getPassword())) {
                System.setProperty(PROXY_PASS, proxyConfiguration.getPassword());
            }
        } else {
            LOGGER.info("Clear proxy configs");
            System.clearProperty(PROXY_HOST);
            System.clearProperty(PROXY_PORT);
            System.clearProperty(PROXY_USER);
            System.clearProperty(PROXY_PASS);
        }
    }
}

