/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect;

import com.blackduck.integration.jenkins.detect.DetectRunner;
import com.blackduck.integration.jenkins.detect.extensions.DetectDownloadStrategy;
import com.blackduck.integration.jenkins.service.JenkinsBuildService;

public class DetectFreestyleCommands {
    private final JenkinsBuildService jenkinsBuildService;
    private final DetectRunner detectRunner;

    public DetectFreestyleCommands(JenkinsBuildService jenkinsBuildService, DetectRunner detectRunner) {
        this.jenkinsBuildService = jenkinsBuildService;
        this.detectRunner = detectRunner;
    }

    public void runDetect(String detectArgumentString, DetectDownloadStrategy detectDownloadStrategy) {
        try {
            String remoteJdkHome = this.jenkinsBuildService.getJDKRemoteHomeOrEmpty().orElse(null);
            int exitCode = this.detectRunner.runDetect(remoteJdkHome, detectArgumentString, detectDownloadStrategy);
            if (exitCode > 0) {
                this.jenkinsBuildService.markBuildFailed("Detect failed with exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.jenkinsBuildService.markBuildInterrupted();
        }
        catch (Exception e) {
            this.jenkinsBuildService.markBuildFailed(e);
        }
    }
}

