/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.utils;

import com.adaptavist.tm4j.jenkins.exception.PrintingZipFileContentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class ZipHandler {
    private ZipHandler() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContentFromFilesInZip(File file) {
        if (!file.exists()) {
            throw new PrintingZipFileContentException(String.format("the temporal zip file:%s does not exist", file.getAbsolutePath()));
        }
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            StringBuilder builder = new StringBuilder();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                builder.append(String.format("file with name: '%s' and content:%n", entry.getName()));
                try (InputStream inputStream = zipFile.getInputStream(entry);){
                    builder.append("[start content]%n");
                    builder.append(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    builder.append("not possible to read the content");
                }
                builder.append("%n[end content]%n");
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            throw new PrintingZipFileContentException(String.format("was not possible to read the content for file %s", file.getAbsolutePath(), e));
        }
    }
}

