/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.io;

import hudson.FilePath;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class FileWriter {
    private InputStream zipFile;
    private List<String> fileNames = new ArrayList<String>();

    public FileWriter(InputStream zipFile) {
        this.zipFile = zipFile;
    }

    public void extractFeatureFilesFromZipAndSave(File rootDir, FilePath workspace, String targetPath) throws IOException, InterruptedException {
        if (workspace.isRemote()) {
            this.extractToRemoteNode(rootDir, workspace, targetPath);
        } else {
            this.extractToLocalNode(this.getTargetFeatureFilesPath(targetPath, workspace.getRemote()));
        }
    }

    private void extractToRemoteNode(File rootDir, FilePath workspace, String targetPath) throws IOException, InterruptedException {
        String targetFeatureFilesPath = rootDir.getPath() + "/" + targetPath;
        this.extractToLocalNode(targetFeatureFilesPath);
        FilePath localNodeFilePath = new FilePath(new File(targetFeatureFilesPath));
        FilePath remoteNodeFilePath = new FilePath(workspace.getChannel(), workspace.getRemote() + "/" + targetPath);
        remoteNodeFilePath.deleteContents();
        localNodeFilePath.copyRecursiveTo("**/*.feature", remoteNodeFilePath);
    }

    private String getTargetFeatureFilesPath(String targetPath, String remote) {
        return remote + "/" + targetPath;
    }

    private void extractToLocalNode(String targetFeatureFilesPath) throws IOException {
        ZipEntry entry;
        this.createFolderIfItDoesNotExist(targetFeatureFilesPath);
        this.cleanUpFolder(targetFeatureFilesPath);
        ZipInputStream zipInputStream = new ZipInputStream(this.zipFile);
        while ((entry = zipInputStream.getNextEntry()) != null) {
            this.fileNames.add(entry.getName());
            this.saveFeatureFile(zipInputStream, targetFeatureFilesPath, entry);
            zipInputStream.closeEntry();
        }
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    private void createFolderIfItDoesNotExist(String targetFeatureFilesPath) throws IOException {
        Path path = Paths.get(targetFeatureFilesPath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private void cleanUpFolder(String targetFeatureFilesPath) throws IOException {
        FileUtils.cleanDirectory((File)Paths.get(targetFeatureFilesPath, new String[0]).toFile());
    }

    private void saveFeatureFile(InputStream zipInputStream, String targetFeatureFilesPath, ZipEntry zipEntry) throws IOException {
        int length;
        byte[] buffer = new byte[2048];
        File zipEntryFile = new File(targetFeatureFilesPath, zipEntry.getName());
        if (!zipEntryFile.toPath().normalize().startsWith(targetFeatureFilesPath)) {
            throw new RuntimeException("Bad zip entry");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(zipEntryFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, buffer.length);
        while ((length = zipInputStream.read(buffer, 0, buffer.length)) >= 0) {
            bufferedOutputStream.write(buffer, 0, length);
        }
        bufferedOutputStream.close();
        fileOutputStream.close();
    }
}

