/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.http;

import com.adaptavist.tm4j.jenkins.exception.NoTestCasesFoundException;
import com.adaptavist.tm4j.jenkins.extensions.ExpandedCustomTestCycle;
import com.adaptavist.tm4j.jenkins.extensions.Instance;
import com.adaptavist.tm4j.jenkins.io.FileReader;
import com.adaptavist.tm4j.jenkins.io.FileWriter;
import com.adaptavist.tm4j.jenkins.utils.Constants;
import com.adaptavist.tm4j.jenkins.utils.ZipHandler;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.exceptions.UnirestException;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class Tm4jJiraRestClient {
    private final Instance jiraInstance;
    private final PrintStream logger;

    public Tm4jJiraRestClient(PrintStream logger, List<Instance> jiraInstances, String name) throws Exception {
        this.logger = logger;
        this.jiraInstance = this.getTm4jInstance(jiraInstances, name);
    }

    public void uploadCucumberFile(String directory, String filePath, String projectKey, Boolean autoCreateTestCases, ExpandedCustomTestCycle expandedCustomTestCycle) throws Exception {
        FileReader fileReader = new FileReader();
        File file = filePath.endsWith("json") ? fileReader.getJsonCucumberZip(directory, filePath, this.logger) : fileReader.getZip(directory, filePath);
        HttpResponse<JsonNode> jsonResponse = this.jiraInstance.publishCucumberFormatBuildResult(projectKey, autoCreateTestCases, file, expandedCustomTestCycle);
        this.processUploadingResultsResponse(jsonResponse);
        this.deleteFile(file);
    }

    public void uploadCustomFormatFile(String directory, String projectKey, Boolean autoCreateTestCases, ExpandedCustomTestCycle expandedCustomTestCycle) throws Exception {
        File file = new FileReader().getZipForCustomFormat(directory);
        HttpResponse<JsonNode> jsonResponse = this.jiraInstance.publishCustomFormatBuildResult(projectKey, autoCreateTestCases, file, expandedCustomTestCycle);
        this.processUploadingResultsResponse(jsonResponse);
        this.deleteFile(file);
    }

    public void uploadJUnitXmlResultFile(String directory, String filePath, String projectKey, Boolean autoCreateTestCases, ExpandedCustomTestCycle expandedCustomTestCycle) throws Exception {
        File file = new FileReader().getZip(directory, filePath);
        try {
            HttpResponse<JsonNode> jsonResponse = this.jiraInstance.publishJUnitFormatBuildResult(projectKey, autoCreateTestCases, file, expandedCustomTestCycle);
            this.processUploadingResultsResponse(jsonResponse);
            this.deleteFile(file);
        }
        catch (Exception e) {
            this.logger.printf("%s An error was raised, the file will not be removed for troubleshooting purposes, when trying to send file on path:'%s' with content:%n %s %n", Constants.ERROR, file.getAbsolutePath(), ZipHandler.getContentFromFilesInZip(file));
            throw e;
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            this.logger.printf("%s The generated ZIP file couldn't be deleted. Please check folder permissions and delete the file manually: %s %n", Constants.INFO, file.getAbsolutePath());
        }
    }

    public void importFeatureFiles(File rootDir, FilePath workspace, String targetPath, String projectKey) throws Exception {
        try {
            HttpResponse<String> httpResponse = this.jiraInstance.downloadFeatureFile(projectKey);
            this.processDownloadingFeatureFilesResponse(rootDir, workspace, targetPath, httpResponse);
        }
        catch (UnirestException e) {
            throw new Exception("Error trying to communicate with Jira", e.getCause());
        }
    }

    private void processDownloadingFeatureFilesResponse(File rootDir, FilePath workspace, String targetPath, HttpResponse<String> httpResponse) throws IOException, InterruptedException {
        if (this.isSuccessful(httpResponse)) {
            if (httpResponse.getStatus() == 204) {
                throw new NoTestCasesFoundException();
            }
            FileWriter fileWriter = new FileWriter(httpResponse.getRawBody());
            fileWriter.extractFeatureFilesFromZipAndSave(rootDir, workspace, targetPath);
            this.logger.printf("%s %s feature files downloaded to %s %n", Constants.INFO, fileWriter.getFileNames().size(), workspace);
        } else {
            if (this.isClientError(httpResponse)) {
                if (httpResponse.getStatus() == 400) {
                    this.processErrorMessages(httpResponse);
                }
                throw new RuntimeException("There was an error while trying to request from Jira. Http Status Code: " + httpResponse.getStatus());
            }
            if (this.isServerError(httpResponse)) {
                throw new RuntimeException(MessageFormat.format("There was an error with the Jira Instance({0}). Http Status Code: {1}", this.jiraInstance.name(), httpResponse.getStatus()));
            }
        }
    }

    private void processUploadingResultsResponse(HttpResponse<JsonNode> jsonResponse) {
        if (this.isSuccessful(jsonResponse)) {
            JSONObject testRun = (JSONObject)((JsonNode)jsonResponse.getBody()).getObject().get("testCycle");
            String testCycleKey = (String)testRun.get("key");
            String testCycleUrl = (String)testRun.get("url");
            this.logger.printf("%s Test Cycle created with the following KEY: %s. %s %n", Constants.INFO, testCycleKey, testCycleUrl);
            this.logger.printf("%s Test results published to Zephyr successfully.%n", Constants.INFO);
        } else {
            if (this.isClientError(jsonResponse)) {
                this.processErrorMessages(jsonResponse);
                this.logger.printf("%s Test Cycle was not created %n", Constants.ERROR);
                throw new RuntimeException("There was an error while trying to import files to Jira. Http Status Code: " + jsonResponse.getStatus());
            }
            if (this.isServerError(jsonResponse)) {
                throw new RuntimeException(MessageFormat.format("There was an error with the Jira Instance({0}). Http Status Code: {1}", this.jiraInstance.name(), jsonResponse.getStatus()));
            }
        }
    }

    private void processErrorMessages(HttpResponse<?> httpResponse) {
        try {
            JSONObject jsonObject = new JsonNode(httpResponse.getBody().toString()).getObject();
            if (jsonObject != null) {
                this.logger.printf("%s Error: %n%n%s%n%n", Constants.ERROR, jsonObject.toString(2));
            }
        }
        catch (Exception e) {
            this.logger.printf("%s Could not parse error message %n", Constants.ERROR);
        }
    }

    private boolean isSuccessful(HttpResponse<?> httpResponse) {
        return httpResponse.getStatus() >= 200 && httpResponse.getStatus() < 300;
    }

    private boolean isClientError(HttpResponse<?> httpResponse) {
        return httpResponse.getStatus() >= 400 && httpResponse.getStatus() < 500;
    }

    private boolean isServerError(HttpResponse<?> httpResponse) {
        return httpResponse.getStatus() >= 500;
    }

    private Instance getTm4jInstance(List<Instance> jiraInstances, String name) throws Exception {
        if (jiraInstances == null) {
            throw new IllegalStateException("There are no Jira instances configured. Please, go to Jenkins global configurations and add some Jira instances.");
        }
        for (Instance jiraInstance : jiraInstances) {
            if (!StringUtils.isNotBlank((String)jiraInstance.name()) || !jiraInstance.name().trim().equals(name)) continue;
            return jiraInstance;
        }
        throw new Exception(MessageFormat.format("Jira instance not found for this server address {0}", name));
    }
}

