/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.extensions.configuration;

import com.adaptavist.tm4j.jenkins.extensions.Instance;
import com.adaptavist.tm4j.jenkins.extensions.JiraCloudInstance;
import com.adaptavist.tm4j.jenkins.extensions.JiraInstance;
import com.adaptavist.tm4j.jenkins.extensions.JiraServerInstance;
import com.adaptavist.tm4j.jenkins.utils.FormHelper;
import com.adaptavist.tm4j.jenkins.utils.Permissions;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"zephyr"})
public class Tm4jGlobalConfiguration
extends GlobalConfiguration {
    private static final String CLOUD_TYPE = "cloud";
    private static final String SERVER_TYPE = "server";
    private static final String JIRA_INSTANCES = "jiraInstances";
    private Collection<JiraInstance> jiraInstances;

    public Tm4jGlobalConfiguration() {
        this.load();
    }

    @Nonnull
    public String getDisplayName() {
        return "Zephyr configuration";
    }

    public boolean configure(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
        Permissions.checkAdminPermission();
        request.bindParameters((Object)this);
        ArrayList<JiraInstance> newJiraInstances = new ArrayList<JiraInstance>();
        try {
            Object formJiraInstances = formData.get(JIRA_INSTANCES);
            JSONArray jiraInstancesList = new JSONArray();
            if (formJiraInstances instanceof JSONArray) {
                jiraInstancesList = formData.getJSONArray(JIRA_INSTANCES);
            } else if (formJiraInstances instanceof JSONObject) {
                jiraInstancesList.add((Object)formData.getJSONObject(JIRA_INSTANCES));
            }
            for (Object jiraInstance : jiraInstancesList.toArray()) {
                JSONObject instance = ((JSONObject)jiraInstance).getJSONObject("type");
                JiraInstance formInstance = new JiraInstance();
                formInstance.setValue(instance.getString("value"));
                if (CLOUD_TYPE.equalsIgnoreCase(formInstance.getValue())) {
                    formInstance.setJwt(Secret.fromString((String)((String)instance.getOrDefault((Object)"jwt", null))));
                } else if (SERVER_TYPE.equalsIgnoreCase(formInstance.getValue())) {
                    formInstance.setServerAddress((String)instance.getOrDefault((Object)"serverAddress", null));
                    formInstance.setUsername((String)instance.getOrDefault((Object)"username", null));
                    formInstance.setPassword(Secret.fromString((String)((String)instance.getOrDefault((Object)"password", null))));
                } else {
                    throw new Exception("Invalid instance type. value must be either 'cloud' or 'server'");
                }
                this.validate(formInstance);
                newJiraInstances.add(formInstance);
            }
            this.jiraInstances = newJiraInstances;
            this.createJiraInstances(this.jiraInstances);
        }
        catch (Exception e) {
            throw new Descriptor.FormException(MessageFormat.format("Error at global configurations of Zephyr Scale: {0}", e.getMessage()), "testManagementForJira");
        }
        this.save();
        return true;
    }

    private List<Instance> createJiraInstances(Collection<JiraInstance> formJiraInstances) throws Exception {
        ArrayList<Instance> newJiraInstances = new ArrayList<Instance>();
        if (formJiraInstances == null) {
            return newJiraInstances;
        }
        for (JiraInstance instance : formJiraInstances) {
            newJiraInstances.add(this.createInstance(instance));
        }
        return newJiraInstances;
    }

    private Instance createInstance(JiraInstance jsonJiraInstance) throws Exception {
        if (CLOUD_TYPE.equals(jsonJiraInstance.getValue())) {
            return this.createCloudInstance(jsonJiraInstance);
        }
        return this.createServerInstance(jsonJiraInstance);
    }

    private JiraServerInstance createServerInstance(JiraInstance formJiraInstance) throws Exception {
        JiraServerInstance jiraServerInstance = this.getServerInstance(formJiraInstance);
        if (jiraServerInstance.isValidCredentials().booleanValue()) {
            return jiraServerInstance;
        }
        throw new Exception("Invalid credentials");
    }

    private JiraCloudInstance createCloudInstance(JiraInstance formJiraInstance) throws Exception {
        JiraCloudInstance jiraInstance = this.getCloudInstance(formJiraInstance);
        Secret jwt = formJiraInstance.getJwt();
        jiraInstance.setJwt(jwt);
        if (jiraInstance.isValidCredentials().booleanValue()) {
            return jiraInstance;
        }
        throw new Exception("Invalid credentials");
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter String serverAddress, @QueryParameter String username, @QueryParameter String password, @QueryParameter String jwt, @QueryParameter String type) {
        Permissions.checkAdminPermission();
        return new FormHelper().testConnection(serverAddress, username, password, jwt, type);
    }

    @POST
    public FormValidation doCheckServerAddress(@QueryParameter String serverAddress) {
        Permissions.checkAdminPermission();
        return new FormHelper().doCheckServerAddress(serverAddress);
    }

    @POST
    public FormValidation doCheckUsername(@QueryParameter String username) {
        Permissions.checkAdminPermission();
        return new FormHelper().doCheckUsername(username);
    }

    @POST
    public FormValidation doCheckPassword(@QueryParameter String password) {
        Permissions.checkAdminPermission();
        return new FormHelper().doCheckPassword(password);
    }

    @POST
    public FormValidation doCheckJwt(@QueryParameter String jwt) {
        Permissions.checkAdminPermission();
        return new FormHelper().doCheckJwt(jwt);
    }

    public List<Instance> getJiraInstances() {
        if (Objects.isNull(this.jiraInstances)) {
            return Collections.emptyList();
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (JiraInstance instance : this.jiraInstances) {
            try {
                this.validate(instance);
                if (CLOUD_TYPE.equals(instance.getValue())) {
                    instances.add(this.getCloudInstance(instance));
                    continue;
                }
                instances.add(this.getServerInstance(instance));
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return instances;
    }

    @DataBoundSetter
    public void setJiraInstances(Collection<JiraInstance> jiraInstances) {
        this.jiraInstances = jiraInstances;
    }

    private JiraCloudInstance getCloudInstance(JiraInstance formJiraInstance) {
        JiraCloudInstance jiraCloudInstance = new JiraCloudInstance();
        jiraCloudInstance.setValue(CLOUD_TYPE);
        Secret jwt = formJiraInstance.getJwt();
        jiraCloudInstance.setJwt(jwt);
        return jiraCloudInstance;
    }

    private JiraServerInstance getServerInstance(JiraInstance formJiraInstance) {
        JiraServerInstance jiraServerInstance = new JiraServerInstance();
        String serverAddress = formJiraInstance.getServerAddress();
        String username = formJiraInstance.getUsername();
        Secret password = formJiraInstance.getPassword();
        jiraServerInstance.setServerAddress(StringUtils.removeEnd((String)serverAddress.trim(), (String)"/"));
        jiraServerInstance.setUsername(username.trim());
        jiraServerInstance.setPassword(password);
        jiraServerInstance.setValue(SERVER_TYPE);
        return jiraServerInstance;
    }

    private void validate(JiraInstance jiraInstance) throws Exception {
        if (jiraInstance.getValue() == null) {
            throw new Exception("Invalid instance type. value must be either 'cloud' or 'server'");
        }
        if (CLOUD_TYPE.equalsIgnoreCase(jiraInstance.getValue())) {
            this.validateCloudInstance(jiraInstance);
        } else if (SERVER_TYPE.equalsIgnoreCase(jiraInstance.getValue())) {
            this.validateServerInstance(jiraInstance);
        } else {
            throw new Exception("Invalid instance type. value must be either 'cloud' or 'server'");
        }
    }

    private void validateServerInstance(JiraInstance jiraInstance) throws Exception {
        String serverAddress = jiraInstance.getServerAddress();
        String username = jiraInstance.getUsername();
        Secret password = jiraInstance.getPassword();
        if (StringUtils.isBlank((String)serverAddress)) {
            throw new Exception("Please enter the server name");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new Exception("Please enter the username");
        }
        if (StringUtils.isBlank((String)password.getPlainText())) {
            throw new Exception("Please enter the password");
        }
    }

    private void validateCloudInstance(JiraInstance jiraInstance) throws Exception {
        Secret jwt = jiraInstance.getJwt();
        if (StringUtils.isBlank((String)jwt.getPlainText())) {
            throw new Exception("Please enter the API key");
        }
    }
}

