/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.extensions;

import com.adaptavist.tm4j.jenkins.extensions.ExpandedCustomTestCycle;
import com.adaptavist.tm4j.jenkins.extensions.Instance;
import com.adaptavist.tm4j.jenkins.utils.GsonUtils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import hudson.util.Secret;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class JiraServerInstance
extends Instance {
    private static final String CUCUMBER_ENDPOINT = "{0}/rest/atm/1.0/automation/execution/cucumber/{1}";
    private static final String CUSTOM_FORMAT_ENDPOINT = "{0}/rest/atm/1.0/automation/execution/{1}";
    private static final String FEATURE_FILES_ENDPOINT = "{0}/rest/atm/1.0/automation/testcases";
    private static final String HEALTH_CHECK_ENDPOINT = "{0}/rest/atm/1.0/healthcheck/";
    private static final Logger LOGGER = Logger.getLogger(JiraServerInstance.class.getName());
    private String serverAddress;
    private String username;
    private Secret password;

    public JiraServerInstance() {
        this.setUnirestHttpClient(this.getNewHttpClient());
    }

    public JiraServerInstance(String serverAddress, String username, Secret password) {
        this.setUnirestHttpClient(this.getNewHttpClient());
        this.serverAddress = serverAddress;
        this.username = username;
        this.password = password;
    }

    @Override
    public final Boolean cloud() {
        return false;
    }

    @Override
    public String name() {
        return this.serverAddress;
    }

    @Override
    public final Boolean isValidCredentials() {
        try {
            String url = MessageFormat.format(HEALTH_CHECK_ENDPOINT, this.serverAddress);
            HttpResponse response = Unirest.get((String)url).basicAuth(this.username, this.getPlainTextPassword()).asString();
            return response.getStatus() == 200;
        }
        catch (UnirestException e) {
            LOGGER.log(Level.WARNING, "Invalid server instance credentials", e);
            return false;
        }
    }

    @Override
    public HttpResponse<String> downloadFeatureFile(String projectKey) throws UnirestException {
        String url = MessageFormat.format(FEATURE_FILES_ENDPOINT, this.serverAddress);
        String tql = String.format("testCase.projectKey = '%s'", projectKey);
        return Unirest.get((String)url).basicAuth(this.username, this.getPlainTextPassword()).queryString("tql", (Object)tql).asString();
    }

    @Override
    public HttpResponse<JsonNode> publishCucumberFormatBuildResult(String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        String url = MessageFormat.format(CUCUMBER_ENDPOINT, this.serverAddress, projectKey);
        return this.importBuildResultsFile(autoCreateTestCases, zip, url, expandedCustomTestCycle);
    }

    @Override
    public HttpResponse<JsonNode> publishCustomFormatBuildResult(String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        String url = MessageFormat.format(CUSTOM_FORMAT_ENDPOINT, this.serverAddress, projectKey);
        return this.importBuildResultsFile(autoCreateTestCases, zip, url, expandedCustomTestCycle);
    }

    @Override
    public HttpResponse<JsonNode> publishJUnitFormatBuildResult(String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        throw new RuntimeException("Not implemented for Zephyr Server/DC");
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public Secret getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(Secret password) {
        this.password = password;
    }

    private HttpResponse<JsonNode> importBuildResultsFile(Boolean autoCreateTestCases, File zip, String url, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        MultipartBody body = Unirest.post((String)url).basicAuth(this.username, this.getPlainTextPassword()).queryString("autoCreateTestCases", (Object)autoCreateTestCases).field("file", zip);
        if (expandedCustomTestCycle != null && !expandedCustomTestCycle.isEmpty()) {
            body.field("testCycle", GsonUtils.getInstance().toJson((Object)expandedCustomTestCycle), "application/json");
        }
        return this.getBodyAsJsonOrThrowExceptionWithBody(body);
    }

    private String getPlainTextPassword() {
        return Secret.toString((Secret)this.password);
    }

    private HttpClient getNewHttpClient() {
        return HttpClientBuilder.create().disableCookieManagement().build();
    }

    protected void setUnirestHttpClient(HttpClient httpClient) {
        Unirest.setHttpClient((HttpClient)httpClient);
    }
}

