/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.extensions;

import com.adaptavist.tm4j.jenkins.exception.InvalidJwtException;
import com.adaptavist.tm4j.jenkins.extensions.ExpandedCustomTestCycle;
import com.adaptavist.tm4j.jenkins.extensions.Instance;
import com.adaptavist.tm4j.jenkins.utils.GsonUtils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import com.nimbusds.jwt.JWTParser;
import hudson.util.Secret;
import java.io.File;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minidev.json.JSONObject;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class JiraCloudInstance
extends Instance {
    private static final String CUCUMBER_ENDPOINT = "{0}/v2/automations/executions/cucumber";
    private static final String JUNIT_ENDPOINT = "{0}/v2/automations/executions/junit";
    private static final String CUSTOM_FORMAT_ENDPOINT = "{0}/v2/automations/executions/custom";
    private static final String FEATURE_FILES_ENDPOINT = "{0}/v2/automations/testcases";
    private static final String HEALTH_CHECK_ENDPOINT = "{0}/v2/healthcheck";
    private static final String API_BASE_URL = "https://api.zephyrscale.smartbear.com";
    private static final Logger LOGGER = Logger.getLogger(JiraCloudInstance.class.getName());
    private String cloudAddress;
    private Secret jwt;
    private String name;

    public JiraCloudInstance() {
        this.setUnirestHttpClient(this.getNewHttpClient());
    }

    public JiraCloudInstance(Secret jwt) {
        this.setJwt(jwt);
        this.setUnirestHttpClient(this.getNewHttpClient());
    }

    @Override
    public Boolean cloud() {
        return true;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCloudAddress() {
        return this.cloudAddress;
    }

    @Override
    public Boolean isValidCredentials() {
        try {
            String url = MessageFormat.format(HEALTH_CHECK_ENDPOINT, API_BASE_URL);
            HttpResponse response = Unirest.get((String)url).header("Authorization", "Bearer " + this.getDecryptedJwt()).asString();
            return response.getStatus() == 200;
        }
        catch (UnirestException e) {
            LOGGER.log(Level.WARNING, String.format("Couldn't connect to Zephyr public REST API at: %s", API_BASE_URL), e);
            return false;
        }
    }

    @Override
    public HttpResponse<JsonNode> publishCucumberFormatBuildResult(String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        String url = MessageFormat.format(CUCUMBER_ENDPOINT, API_BASE_URL);
        return this.exportResultsFile(url, projectKey, autoCreateTestCases, zip, expandedCustomTestCycle);
    }

    @Override
    public HttpResponse<JsonNode> publishCustomFormatBuildResult(String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        String url = MessageFormat.format(CUSTOM_FORMAT_ENDPOINT, API_BASE_URL);
        return this.exportResultsFile(url, projectKey, autoCreateTestCases, zip, expandedCustomTestCycle);
    }

    @Override
    public HttpResponse<JsonNode> publishJUnitFormatBuildResult(String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        String url = MessageFormat.format(JUNIT_ENDPOINT, API_BASE_URL);
        return this.exportResultsFile(url, projectKey, autoCreateTestCases, zip, expandedCustomTestCycle);
    }

    @Override
    public HttpResponse<String> downloadFeatureFile(String projectKey) throws UnirestException {
        String url = MessageFormat.format(FEATURE_FILES_ENDPOINT, API_BASE_URL);
        return Unirest.get((String)url).header("Authorization", "Bearer " + this.getDecryptedJwt()).header("Accept", "application/zip").queryString("projectKey", (Object)projectKey).asString();
    }

    @Override
    public Secret getJwt() {
        return this.jwt;
    }

    @Override
    public void setJwt(Secret jwt) {
        this.jwt = jwt;
        this.cloudAddress = this.name = this.getBaseUrl();
    }

    public Boolean getCloud() {
        return true;
    }

    private String getBaseUrl() {
        try {
            Object context = JWTParser.parse((String)this.getDecryptedJwt()).getJWTClaimsSet().getClaim("context");
            if (context instanceof JSONObject) {
                return (String)((JSONObject)context).get((Object)"baseUrl");
            }
            LOGGER.log(Level.WARNING, "Invalid jwt. Please provide a valid Zephyr jwt by updating your jira cloud configuration");
            return null;
        }
        catch (ParseException e) {
            throw new InvalidJwtException(e);
        }
    }

    private HttpResponse<JsonNode> exportResultsFile(String url, String projectKey, Boolean autoCreateTestCases, File zip, ExpandedCustomTestCycle expandedCustomTestCycle) throws UnirestException {
        MultipartBody body = Unirest.post((String)url).header("Authorization", "Bearer " + this.getDecryptedJwt()).header("zscale-source", "Jenkins Plugin").queryString("autoCreateTestCases", (Object)autoCreateTestCases).queryString("projectKey", (Object)projectKey).field("file", zip);
        if (expandedCustomTestCycle != null && !expandedCustomTestCycle.isEmpty()) {
            body.field("testCycle", GsonUtils.getInstance().toJson((Object)expandedCustomTestCycle), "application/json");
        }
        return this.getBodyAsJsonOrThrowExceptionWithBody(body);
    }

    private String getDecryptedJwt() {
        return this.jwt.getPlainText();
    }

    private HttpClient getNewHttpClient() {
        return HttpClientBuilder.create().disableCookieManagement().build();
    }

    protected void setUnirestHttpClient(HttpClient httpClient) {
        Unirest.setHttpClient((HttpClient)httpClient);
    }

    @Override
    public void setCloudAddress(String cloudAddress) {
        this.cloudAddress = cloudAddress;
    }
}

