/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.extensions;

import com.adaptavist.tm4j.jenkins.extensions.CustomTestCycle;
import com.adaptavist.tm4j.jenkins.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import hudson.EnvVars;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ExpandedCustomTestCycle {
    protected String name;
    protected String description;
    protected Long jiraProjectVersion;
    protected Long folderId;
    protected Map<String, Object> customFields;

    public ExpandedCustomTestCycle(CustomTestCycle customTestCycle, EnvVars envVars) {
        String expandedName = envVars.expand(customTestCycle.getName());
        String expandedDescription = envVars.expand(customTestCycle.getDescription());
        String expandedJiraProjectVersion = envVars.expand(customTestCycle.getJiraProjectVersion());
        String expandedFolderId = envVars.expand(customTestCycle.getFolderId());
        String expandedCustomFields = envVars.expand(customTestCycle.getCustomFields());
        this.name = this.setStringIfNotBlank(expandedName);
        this.description = this.setStringIfNotBlank(expandedDescription);
        this.jiraProjectVersion = this.convertToLongIfPossible(expandedJiraProjectVersion);
        this.folderId = this.convertToLongIfPossible(expandedFolderId);
        this.customFields = this.convertCustomFieldsToMapIfValid(expandedCustomFields);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJiraProjectVersion() {
        return this.jiraProjectVersion == null ? null : this.jiraProjectVersion.toString();
    }

    public String getFolderId() {
        return this.folderId == null ? null : this.folderId.toString();
    }

    public String getCustomFields() {
        return this.customFields.isEmpty() ? null : GsonUtils.getInstance().toJson(this.customFields);
    }

    public boolean isEmpty() {
        return !(!StringUtils.isBlank((String)this.name) || !StringUtils.isBlank((String)this.description) || this.customFields != null && this.customFields.size() != 0 || this.jiraProjectVersion != null && this.jiraProjectVersion != 0L || this.folderId != null && this.folderId != 0L);
    }

    private String setStringIfNotBlank(String value) {
        return StringUtils.isBlank((String)value) ? null : value;
    }

    private Long convertToLongIfPossible(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Map<String, Object> convertCustomFieldsToMapIfValid(String customFieldsJson) {
        try {
            return new HashMap<String, Object>((Map)GsonUtils.getInstance().fromJson(customFieldsJson, new TypeToken<Map<String, Object>>(){}.getType()));
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    public String toString() {
        return String.format("ExpandedCustomTestCycle: {%n    name: %s,%n    description: %s,%n    jiraProjectVersion: %s,%n    folderId: %s,%n    customFields: %s%n}", this.name, this.description, this.jiraProjectVersion, this.folderId, this.customFields);
    }
}

