/*
 * Decompiled with CFR 0.152.
 */
package cn.opsbox.jenkinsci.plugins.cps;

import cn.opsbox.jenkinsci.plugins.cps.ConsoleOesTemplateFlowDefinitionConfiguration;
import cn.opsbox.jenkinsci.plugins.cps.OesTemplateFlowDefinitionConfiguration;
import cn.opsbox.jenkinsci.plugins.cps.ScmOesTemplateFlowDefinitionConfiguration;
import hudson.AbortException;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import jenkins.scm.api.SCMFileSystem;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public abstract class CpsTemplateFlowDefinition
extends FlowDefinition {
    protected OesTemplateFlowDefinitionConfiguration configProvider;

    static FlowDurabilityHint determineFlowDurabilityHint(FlowExecutionOwner owner) {
        Queue.Executable exec = owner.getExecutable();
        if (!(exec instanceof WorkflowRun)) {
            throw new IllegalStateException("inappropriate context");
        }
        return GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        for (Action action : actions) {
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create((FlowDefinition)this, owner, actions);
        }
        String template = this.initializePipeline(owner);
        FlowDurabilityHint flowDurabilityHint = CpsTemplateFlowDefinition.determineFlowDurabilityHint(owner);
        return new CpsFlowExecution(template, true, owner, flowDurabilityHint);
    }

    String initializePipeline(FlowExecutionOwner owner) {
        String script;
        block20: {
            script = "";
            if (this.configProvider instanceof ConsoleOesTemplateFlowDefinitionConfiguration) {
                ConsoleOesTemplateFlowDefinitionConfiguration console = (ConsoleOesTemplateFlowDefinitionConfiguration)this.configProvider;
                script = console.getScript();
            } else {
                ScmOesTemplateFlowDefinitionConfiguration scm = (ScmOesTemplateFlowDefinitionConfiguration)this.configProvider;
                Queue.Executable _build = owner.getExecutable();
                if (!(_build instanceof Run)) {
                    throw new IOException("can only check out SCM into a Run");
                }
                Run build = (Run)_build;
                SCM scm1 = scm.getScm();
                String scriptPath = scm.getScriptPath();
                TaskListener listener = owner.getListener();
                try (SCMFileSystem fs = SCMFileSystem.of((Item)build.getParent(), (SCM)scm1);){
                    if (fs != null) {
                        try {
                            script = fs.child(scriptPath).contentAsString();
                            listener.getLogger().println("Obtained " + scriptPath + " from " + scm1.getKey());
                            break block20;
                        }
                        catch (FileNotFoundException e) {
                            throw new AbortException("Unable to find " + scriptPath + " from " + scm1.getKey());
                        }
                    }
                    throw new AbortException("Could not get template file " + scriptPath + " from " + scm1.getKey());
                }
            }
        }
        return script;
    }

    public OesTemplateFlowDefinitionConfiguration getConfigProvider() {
        return this.configProvider;
    }
}

