/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import java.io.File;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileCopyOperation
extends FileOperation
implements Serializable {
    private final String includes;
    private final String excludes;
    private final String targetLocation;
    private final boolean flattenFiles;
    private final boolean renameFiles;
    private final String sourceCaptureExpression;
    private final String targetNameExpression;
    private Boolean useDefaultExcludes;

    @DataBoundConstructor
    public FileCopyOperation(String includes, String excludes, String targetLocation, boolean flattenFiles, boolean renameFiles, String sourceCaptureExpression, String targetNameExpression) {
        this.includes = includes;
        this.excludes = excludes;
        this.targetLocation = targetLocation;
        this.flattenFiles = flattenFiles;
        this.renameFiles = renameFiles;
        this.sourceCaptureExpression = sourceCaptureExpression;
        this.targetNameExpression = targetNameExpression;
        this.useDefaultExcludes = true;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public boolean getFlattenFiles() {
        return this.flattenFiles;
    }

    public boolean getRenameFiles() {
        return this.renameFiles;
    }

    public String getSourceCaptureExpression() {
        return this.sourceCaptureExpression;
    }

    public String getTargetNameExpression() {
        return this.targetNameExpression;
    }

    public boolean getUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    @Override
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Copy Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.includes), envVars.expand(this.excludes), envVars.expand(this.targetLocation), this.flattenFiles, this.renameFiles, this.sourceCaptureExpression, this.targetNameExpression, this.useDefaultExcludes));
            }
            catch (RuntimeException e) {
                listener.getLogger().println(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    @DataBoundSetter
    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    protected Object readResolve() {
        if (this.useDefaultExcludes == null) {
            this.useDefaultExcludes = true;
        }
        return this;
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final String resolvedIncludes;
        private final String resolvedExcludes;
        private final String resolvedTargetLocation;
        private final boolean flattenFiles;
        private final boolean renameFiles;
        private final String sourceCaptureExpression;
        private final String targetNameExpression;
        private final boolean useDefaultExcludes;

        public TargetFileCallable(TaskListener Listener, String ResolvedIncludes, String ResolvedExcludes, String ResolvedTargetLocation, boolean flattenFiles, boolean renameFiles, String sourceCaptureExpression, String targetNameExpression, boolean UseDefaultExcludes) {
            this.listener = Listener;
            this.resolvedIncludes = ResolvedIncludes;
            this.resolvedExcludes = ResolvedExcludes;
            this.resolvedTargetLocation = ResolvedTargetLocation;
            this.flattenFiles = flattenFiles;
            this.renameFiles = renameFiles;
            this.sourceCaptureExpression = sourceCaptureExpression;
            this.targetNameExpression = targetNameExpression;
            this.useDefaultExcludes = UseDefaultExcludes;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result;
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath fpTL = new FilePath(fpWS, this.resolvedTargetLocation);
                FilePath[] resolvedFiles = fpWS.list(this.resolvedIncludes, this.resolvedExcludes, this.useDefaultExcludes);
                if (resolvedFiles.length == 0) {
                    this.listener.getLogger().println("0 files found for include pattern '" + this.resolvedIncludes + "' and exclude pattern '" + this.resolvedExcludes + "'");
                }
                if (this.flattenFiles) {
                    for (FilePath item : resolvedFiles) {
                        if (this.renameFiles) {
                            String relativeTargetFileName;
                            String relativePath = item.getRemote().replace(fpWS.getRemote(), ".");
                            String targetFileName = relativePath.equals(relativeTargetFileName = relativePath.replaceAll(this.sourceCaptureExpression, this.targetNameExpression)) ? item.getName() : relativeTargetFileName;
                            FilePath fpTF = new FilePath(fpTL, targetFileName);
                            this.listener.getLogger().println("Copy from " + item.getRemote() + " to " + String.valueOf(fpTF));
                            item.copyTo(fpTF);
                            continue;
                        }
                        this.listener.getLogger().println(item.getRemote());
                        item.copyTo(new FilePath(fpTL, item.getName()));
                    }
                    result = true;
                } else {
                    for (FilePath item : resolvedFiles) {
                        this.listener.getLogger().println(item.getRemote());
                    }
                    fpWS.copyRecursiveTo((DirScanner)new DirScanner.Glob(this.resolvedIncludes, this.resolvedExcludes, this.useDefaultExcludes), fpTL, this.resolvedIncludes);
                    result = true;
                }
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    @Extension
    @Symbol(value={"fileCopyOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "File Copy";
        }
    }
}

