/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class TrueZipArchiver
extends Archiver {
    public static final ArchiverFactory FACTORY = new Factory();
    private static final long BITMASK_IS_DIRECTORY = 16L;
    private final byte[] buf = new byte[8192];
    private final ZipOutputStream zip;

    TrueZipArchiver(OutputStream out) {
        this(out, Charset.defaultCharset());
    }

    TrueZipArchiver(OutputStream out, Charset cs) {
        this.zip = new ZipOutputStream(out, cs == null ? Charset.defaultCharset() : cs);
    }

    public void visit(File f, String rawRelativePath) throws IOException {
        String relativePath = rawRelativePath.replace('\\', '/');
        if (f.isDirectory()) {
            ZipEntry dirZipEntry = new ZipEntry(relativePath + "/");
            dirZipEntry.setExternalAttributes(16L);
            dirZipEntry.setTime(f.lastModified());
            this.zip.putNextEntry(dirZipEntry);
            this.zip.closeEntry();
        } else {
            ZipEntry fileZipEntry = new ZipEntry(relativePath);
            fileZipEntry.setTime(f.lastModified());
            this.zip.putNextEntry(fileZipEntry);
            try (InputStream in = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                int len = in.read(this.buf);
                while (len >= 0) {
                    this.zip.write(this.buf, 0, len);
                    len = in.read(this.buf);
                }
            }
            this.zip.closeEntry();
        }
        ++this.entriesWritten;
    }

    public void close() throws IOException {
        this.zip.close();
    }

    private static final class Factory
    extends ArchiverFactory {
        private static final long serialVersionUID = 1L;

        private Factory() {
        }

        public Archiver create(OutputStream out) {
            return new TrueZipArchiver(out);
        }

        public Archiver create(OutputStream out, Charset charset) {
            return new TrueZipArchiver(out, charset);
        }
    }
}

