/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.yandex.qatools.allure.jenkins.utils.BuildSummary;
import ru.yandex.qatools.allure.jenkins.utils.ZipUtils;

public final class FilePathUtils {
    private static final String ALLURE_PREFIX = "allure";
    private static final String ALLURE_REPORT_ZIP = "allure-report.zip";
    private static final Logger LOG = Logger.getLogger(FilePathUtils.class.getName());
    private static final String KEY_PASSED = "passed";
    private static final String KEY_FAILED = "failed";
    private static final String KEY_BROKEN = "broken";
    private static final String KEY_SKIPPED = "skipped";
    private static final String KEY_UNKNOWN = "unknown";
    private static final String DIR_EXPORT = "export";
    private static final String DIR_WIDGETS = "widgets";
    private static final String FILE_SUMMARY = "summary.json";
    private static final String KEY_STATISTIC = "statistic";
    public static final String SEPARATOR = "/";

    private FilePathUtils() {
    }

    public static void copyRecursiveTo(FilePath from, FilePath to, AbstractBuild build, PrintStream logger) throws IOException, InterruptedException {
        if (from.isRemote() && to.isRemote()) {
            FilePath tmpMasterFilePath = new FilePath(build.getRootDir()).createTempDir(ALLURE_PREFIX, null);
            from.copyRecursiveTo(tmpMasterFilePath);
            tmpMasterFilePath.copyRecursiveTo(to);
            FilePathUtils.deleteRecursive(tmpMasterFilePath, logger);
        } else {
            from.copyRecursiveTo(to);
        }
    }

    public static void deleteRecursive(FilePath filePath, PrintStream logger) {
        try {
            filePath.deleteContents();
            filePath.deleteRecursive();
        }
        catch (IOException | InterruptedException e) {
            logger.printf("Can't delete directory [%s]%n", filePath);
        }
    }

    public static FilePath getPreviousReportWithHistory(Run<?, ?> run, String reportPath) throws IOException, InterruptedException {
        for (Run current = run; current != null; current = current.getPreviousCompletedBuild()) {
            FilePath previousReport = new FilePath(current.getArtifactsDir()).child(ALLURE_REPORT_ZIP);
            if (!previousReport.exists() || !FilePathUtils.isHistoryNotEmpty(previousReport, reportPath)) continue;
            return previousReport;
        }
        return null;
    }

    private static boolean isHistoryNotEmpty(FilePath previousReport, String reportPath) throws IOException {
        block11: {
            try (ZipFile archive = new ZipFile(previousReport.getRemote());){
                boolean bl;
                block12: {
                    List<ZipEntry> entries = ZipUtils.listEntries(archive, reportPath + "/history/history.json");
                    if (!Integer.valueOf(entries.size()).equals(1)) break block11;
                    ZipEntry historyEntry = entries.get(0);
                    InputStream is = archive.getInputStream(historyEntry);
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        JsonNode historyJson = mapper.readTree(is);
                        bl = historyJson.elements().hasNext();
                        if (is == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BuildSummary extractSummary(Run<?, ?> run, String reportPath) {
        block24: {
            FilePath reportZip = new FilePath(run.getArtifactsDir()).child(ALLURE_REPORT_ZIP);
            try {
                if (!reportZip.exists()) break block24;
                try (ZipFile archive = new ZipFile(reportZip.getRemote());){
                    BuildSummary buildSummary;
                    block25: {
                        Optional<ZipEntry> summary = FilePathUtils.getSummary(archive, reportPath, DIR_EXPORT);
                        if (summary.isEmpty()) {
                            summary = FilePathUtils.getSummary(archive, reportPath, DIR_WIDGETS);
                        }
                        if (!summary.isPresent()) break block24;
                        InputStream is = archive.getInputStream(summary.get());
                        try {
                            buildSummary = FilePathUtils.parseSummaryJson(is);
                            if (is == null) break block25;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return buildSummary;
                }
            }
            catch (IOException | InterruptedException ex) {
                LOG.log(Level.FINE, "Unable to read Allure summary from ZIP for {0}: {1}", new Object[]{reportPath, ex.toString()});
            }
        }
        try {
            FilePath reportDir = new FilePath(run.getRootDir()).child(reportPath);
            FilePath json = reportDir.child(DIR_EXPORT).child(FILE_SUMMARY);
            if (!json.exists()) {
                json = reportDir.child(DIR_WIDGETS).child(FILE_SUMMARY);
            }
            if (json.exists()) {
                try (InputStream is = json.read();){
                    BuildSummary buildSummary = FilePathUtils.parseSummaryJson(is);
                    return buildSummary;
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            LOG.log(Level.FINE, "Unable to read Allure summary from unpacked dir for {0}: {1}", new Object[]{reportPath, ex.toString()});
        }
        return new BuildSummary().withStatistics(new HashMap<String, Integer>());
    }

    private static BuildSummary parseSummaryJson(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(inputStream);
        JsonNode statisticNode = root.hasNonNull(KEY_STATISTIC) ? root.get(KEY_STATISTIC) : root;
        HashMap<String, Integer> statistics = new HashMap<String, Integer>(5);
        statistics.put(KEY_PASSED, FilePathUtils.nodeAsInt(statisticNode.get(KEY_PASSED)));
        statistics.put(KEY_FAILED, FilePathUtils.nodeAsInt(statisticNode.get(KEY_FAILED)));
        statistics.put(KEY_BROKEN, FilePathUtils.nodeAsInt(statisticNode.get(KEY_BROKEN)));
        statistics.put(KEY_SKIPPED, FilePathUtils.nodeAsInt(statisticNode.get(KEY_SKIPPED)));
        statistics.put(KEY_UNKNOWN, FilePathUtils.nodeAsInt(statisticNode.get(KEY_UNKNOWN)));
        return new BuildSummary().withStatistics(statistics);
    }

    private static int nodeAsInt(JsonNode node) {
        return node == null || node.isNull() ? 0 : node.asInt(0);
    }

    private static Optional<ZipEntry> getSummary(ZipFile archive, String reportPath, String location) {
        List<ZipEntry> entries = ZipUtils.listEntries(archive, reportPath.concat(SEPARATOR).concat(location));
        String toSearch = reportPath.concat(SEPARATOR).concat(location).concat(SEPARATOR).concat(FILE_SUMMARY);
        return entries.stream().filter(Objects::nonNull).filter(input -> input.getName().equals(toSearch)).findFirst();
    }
}

