/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.config;

import hudson.model.Result;
import ru.yandex.qatools.allure.jenkins.utils.BuildSummary;

public enum ResultPolicy {
    LEAVE_AS_IS,
    UNSTABLE_IF_FAILED_OR_BROKEN,
    FAILURE_IF_FAILED_OR_BROKEN;


    public Result decide(BuildSummary summary) {
        boolean hasProblems = summary.getFailedCount() > 0L || summary.getBrokenCount() > 0L;
        switch (this) {
            case LEAVE_AS_IS: {
                return null;
            }
            case FAILURE_IF_FAILED_OR_BROKEN: {
                if (hasProblems) {
                    return Result.FAILURE;
                }
                return Result.SUCCESS;
            }
        }
        if (hasProblems) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }
}

