/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.jenkins.plugins.postcompleted;

import com.squareup.okhttp.OkHttpClient;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class PostCompletedRunListener
extends RunListener<Run>
implements Describable<PostCompletedRunListener> {
    private final OkHttpClient client = new OkHttpClient();
    private static final Logger LOG = Logger.getLogger(PostCompletedRunListener.class.getName());

    public void onStarted(Run run, TaskListener listener) {
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        String urlToSubmitTo = this.getDescriptor().getUrlToSubmitTo();
        try {
            new URL(urlToSubmitTo);
        }
        catch (MalformedURLException e) {
            LOG.info("The url to submit to is not valid, please check your global configuration");
            return;
        }
        String resultUrl = Jenkins.getInstance().getRootUrl() + run.getUrl();
        LOG.info(run.getParent().getName() + "#" + run.getNumber() + " is posting its result url : " + resultUrl + " to : " + urlToSubmitTo);
        byte[] body = new byte[]{};
        try {
            body = this.createBody(resultUrl).getBytes("UTF-8");
            String result = this.post(new URL(urlToSubmitTo), body);
            LOG.info(result);
        }
        catch (IOException e) {
            LOG.warning(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(URL url, byte[] body) throws IOException {
        HttpURLConnection connection = this.client.open(url);
        OutputStream out = null;
        InputStream in = null;
        try {
            connection.setRequestMethod("POST");
            out = connection.getOutputStream();
            out.write(body);
            out.close();
            if (connection.getResponseCode() != 201 && connection.getResponseCode() != 200) {
                throw new IOException("Unexpected HTTP response: " + connection.getResponseCode() + " " + connection.getResponseMessage() + " when posting the url to " + url);
            }
            in = connection.getInputStream();
            String string = this.readFirstLine(in);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private String readFirstLine(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        return reader.readLine();
    }

    private String createBody(String url) {
        return "url=" + url;
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<PostCompletedRunListener> {
        private String urlToSubmitTo;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Say hello world";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.urlToSubmitTo = formData.getString("urlToSubmitTo");
            this.save();
            return super.configure(req, formData);
        }

        public String getUrlToSubmitTo() {
            return this.urlToSubmitTo;
        }
    }
}

