/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.jenkins.plugins.acceleratedbuildnow;

import hudson.maven.MavenBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.queue.QueueSorter;
import hudson.model.queue.QueueTaskFuture;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.terracotta.jenkins.plugins.acceleratedbuildnow.AcceleratedBuildNowAction;
import org.terracotta.jenkins.plugins.acceleratedbuildnow.AcceleratedBuildNowBadgeAction;
import org.terracotta.jenkins.plugins.acceleratedbuildnow.AcceleratedBuildNowSorter;
import org.terracotta.jenkins.plugins.acceleratedbuildnow.AcceleratedBuildNowVictimBadgeAction;

public class AcceleratedBuildNowAction
implements Action {
    private static final Logger LOG = Logger.getLogger(AcceleratedBuildNowAction.class.getName());
    private final AbstractProject project;

    public AcceleratedBuildNowAction(AbstractProject abstractProject) {
        this.project = abstractProject;
    }

    public String getDisplayName() {
        if (this.project.hasPermission(Item.BUILD)) {
            return "Accelerated Build Now !";
        }
        return null;
    }

    public String getIconFileName() {
        if (this.project.hasPermission(Item.BUILD)) {
            return "/plugin/accelerated-build-now-plugin/images/icon-64x64.jpg";
        }
        return null;
    }

    public String getUrlName() {
        if (this.project.hasPermission(Item.BUILD)) {
            return "accelerated";
        }
        return null;
    }

    public void doBuild(StaplerRequest request, StaplerResponse response) throws ServletException, IOException, InterruptedException, ExecutionException {
        boolean jenkinsIsFreeToBuild;
        if (!this.project.hasPermission(Item.BUILD)) {
            response.sendRedirect(request.getContextPath() + '/' + this.project.getUrl());
        }
        LOG.info("project : " + this.project.getName() + " needs to be built NOW !");
        Label assignedLabel = this.project.getAssignedLabel();
        boolean alreadyTakenCareOf = this.project.getLastBuild() != null && this.project.getLastBuild().isBuilding() || this.queueSorterPriorityOn(this.project);
        boolean bl = jenkinsIsFreeToBuild = Jenkins.getInstance().getQueue().isEmpty() && this.atLeastOneExecutorIsIdle(assignedLabel);
        if (alreadyTakenCareOf || jenkinsIsFreeToBuild) {
            LOG.info("No need for AcceleratedBuildNow plugin (already building or empty queue with idle executors");
            this.project.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), new Action[0]);
            if (Jenkins.getInstance().getQueue().getSorter() != null && Jenkins.getInstance().getQueue().getBuildableItems() != null) {
                Jenkins.getInstance().getQueue().getSorter().sortBuildableItems(Jenkins.getInstance().getQueue().getBuildableItems());
            }
            response.sendRedirect(request.getContextPath() + '/' + this.project.getUrl());
            return;
        }
        QueueTaskFuture queueTaskFuture = this.project.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), new Action[0]);
        LOG.info("project : " + this.project.getName() + " is scheduled to build now !");
        QueueSorter originalQueueSorter = Jenkins.getInstance().getQueue().getSorter();
        AcceleratedBuildNowSorter acceleratedBuildNowSorter = new AcceleratedBuildNowSorter(this.project, originalQueueSorter);
        Jenkins.getInstance().getQueue().setSorter((QueueSorter)acceleratedBuildNowSorter);
        Jenkins.getInstance().getQueue().getSorter().sortBuildableItems(Jenkins.getInstance().getQueue().getBuildableItems());
        AbstractBuild killedBuild = null;
        List allItems = Jenkins.getInstance().getAllItems(AbstractProject.class);
        for (AbstractProject projectConsidered : allItems) {
            AbstractBuild lastBuild = this.getLastBuild(projectConsidered);
            if (lastBuild == null || !lastBuild.isBuilding() || !this.isBuildNotTriggeredByHuman(lastBuild) || !this.slaveRunningBuildCompatible(lastBuild, assignedLabel)) continue;
            LOG.info("project : " + lastBuild.getProject().getName() + " #" + lastBuild.getNumber() + " was not scheduled by a human, killing it right now to re schedule it later !");
            Executor executor = this.getExecutor(lastBuild);
            executor.interrupt(Result.ABORTED);
            killedBuild = lastBuild;
            break;
        }
        if (killedBuild == null) {
            LOG.info("project : " + this.project.getName() + " could not be built : no way to build it now !");
        } else {
            AbstractBuild projectBuild = (AbstractBuild)queueTaskFuture.getStartCondition().get();
            LOG.info("build #" + projectBuild.getNumber() + " for " + this.project.getName() + " was launched successfully !");
            projectBuild.getActions().add(new AcceleratedBuildNowBadgeAction(killedBuild));
            killedBuild.getActions().add(new AcceleratedBuildNowVictimBadgeAction(projectBuild));
            this.rescheduleKilledBuild(killedBuild, (Cause)new AcceleratedBuildNowKilledCause(), originalQueueSorter);
        }
        Jenkins.getInstance().getQueue().setSorter(originalQueueSorter);
        response.sendRedirect(request.getContextPath() + '/' + this.project.getUrl());
    }

    private Executor getExecutor(AbstractBuild lastBuild) {
        Executor executorConsidered = null;
        for (Executor executor : lastBuild.getBuiltOn().toComputer().getExecutors()) {
            if (!lastBuild.equals(executor.getCurrentExecutable())) continue;
            executorConsidered = executor;
        }
        return executorConsidered;
    }

    private AbstractBuild getLastBuild(AbstractProject projectConsidered) {
        AbstractBuild lastBuild = projectConsidered.getLastBuild();
        if (lastBuild instanceof MavenBuild) {
            lastBuild = ((MavenBuild)lastBuild).getParentBuild();
        }
        return lastBuild;
    }

    private boolean atLeastOneExecutorIsIdle(Label assignedLabel) {
        int idleExecutors = 0;
        if (assignedLabel == null) {
            HashSet<Object> nodes = new HashSet<Object>();
            Jenkins h = Jenkins.getInstance();
            nodes.add(h);
            for (Node node : h.getNodes()) {
                nodes.add(node);
            }
            for (Node node : nodes) {
                Computer c = node.toComputer();
                if (c == null || !c.isOnline() && !c.isConnecting() || !c.isAcceptingTasks()) continue;
                idleExecutors += c.countIdle();
            }
        } else {
            idleExecutors = assignedLabel.getIdleExecutors();
        }
        return idleExecutors > 0;
    }

    private boolean queueSorterPriorityOn(AbstractProject project) {
        QueueSorter originalQueueSorter = Jenkins.getInstance().getQueue().getSorter();
        return originalQueueSorter instanceof AcceleratedBuildNowSorter && ((AcceleratedBuildNowSorter)originalQueueSorter).getProject().equals(project);
    }

    private boolean isBuildNotTriggeredByHuman(AbstractBuild lastBuild) {
        return lastBuild.getCause(Cause.UserIdCause.class) == null && lastBuild.getCause(Cause.UserCause.class) == null;
    }

    private boolean slaveRunningBuildCompatible(AbstractBuild lastBuild, Label assignedLabel) {
        boolean contains;
        boolean bl = contains = assignedLabel == null ? true : lastBuild.getBuiltOn().getAssignedLabels().contains(assignedLabel);
        if (!contains) {
            LOG.info("build : " + lastBuild.getNumber() + " of project " + lastBuild.getProject().getName() + " is not running on node compatible with " + assignedLabel.getName());
        }
        return contains;
    }

    private void rescheduleKilledBuild(AbstractBuild killedBuild, Cause cause, QueueSorter originalQueueSorter) throws ExecutionException, InterruptedException {
        AcceleratedBuildNowSorter acceleratedBuildNowSorter = new AcceleratedBuildNowSorter(this.project, originalQueueSorter);
        Jenkins.getInstance().getQueue().setSorter((QueueSorter)acceleratedBuildNowSorter);
        QueueTaskFuture queueTaskFuture = killedBuild.getProject().scheduleBuild2(0, cause, new Action[0]);
        LOG.info("build that was killed : " + killedBuild.getProject().getName() + " #" + killedBuild.getNumber() + " is scheduled to build next !");
        Jenkins.getInstance().getQueue().getSorter().sortBuildableItems(Jenkins.getInstance().getQueue().getBuildableItems());
    }
}

