/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpResponseException;
import hudson.EnvVars;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.openshift.jenkins.plugins.openshiftlogin.OAuthSession;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftSetOAuth;

public class OpenShiftPermissionFilter
implements Filter {
    private static final String LAST_SELF_SAR_POLL_TIME = "self-sar-time";
    private static final long SELF_SAR_POLL_INTERVAL = 300000L;
    private static final String OPENSHIFT_PERMISSIONS_POLL_INTERVAL = "OPENSHIFT_PERMISSIONS_POLL_INTERVAL";
    private static final String OPENSHIFT_ACCESS_VIA_BEARER_TOKEN = "OPENSHIFT_ACCESS_VIA_BEARER_TOKEN";
    private static final int MAX_BEARER_CACHE_ENTRIES = 50;
    private static String NEED_TO_AUTH = "\nYou need to supply credentials that allow you to be authenticated by OpenShift OAuth as a valid user who is assigned either the view, edit, or admin roles in the OpenShift project running this Jenkins instance. \nIf operating from a browser, provide your user credentials when solicited by the OpenShift login page.  Otherwise, supply as a part of any HTTP requests you generate a HTTP Authorization Bearer header\ncontaining a token that correlates to your user credentials.\n";
    transient boolean initCalled = false;
    transient LinkedHashMap<String, BearerCacheEntry> bearerCache = new LinkedHashMap<String, BearerCacheEntry>(50){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BearerCacheEntry> eldest) {
            return this.size() > 50;
        }
    };

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block17: {
            try {
                HttpSession s;
                boolean updated = OpenShiftSetOAuth.setOauth(false);
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                long interval = 300000L;
                String var = (String)EnvVars.masterEnvVars.get(OPENSHIFT_PERMISSIONS_POLL_INTERVAL);
                if (var != null) {
                    try {
                        interval = Long.parseLong(var);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if ((s = httpRequest.getSession(false)) != null) {
                    OAuthSession oauth = (OAuthSession)s.getAttribute(OAuthSession.SESSION_NAME);
                    if (oauth == null || oauth.getCredential() == null) break block17;
                    try {
                        Long lastPermissionPoll = (Long)s.getAttribute(OAuthSession.SESSION_NAME + LAST_SELF_SAR_POLL_TIME);
                        if (lastPermissionPoll == null) {
                            lastPermissionPoll = new Long(System.currentTimeMillis());
                            s.setAttribute(OAuthSession.SESSION_NAME + LAST_SELF_SAR_POLL_TIME, (Object)new Long(System.currentTimeMillis()));
                        }
                        if (updated || System.currentTimeMillis() - lastPermissionPoll > interval * 1000L) {
                            OpenShiftOAuth2SecurityRealm secRealm = (OpenShiftOAuth2SecurityRealm)Jenkins.getInstance().getSecurityRealm();
                            secRealm.updateAuthorizationStrategy(oauth.getCredential());
                            s.setAttribute(OAuthSession.SESSION_NAME + LAST_SELF_SAR_POLL_TIME, (Object)new Long(System.currentTimeMillis()));
                        }
                        break block17;
                    }
                    catch (Throwable t) {
                        OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.SEVERE, "filter", t);
                    }
                    break block17;
                }
                if (!(Jenkins.getInstance().getSecurityRealm() instanceof OpenShiftOAuth2SecurityRealm)) break block17;
                try {
                    String[] words;
                    String authHdr;
                    String enabled = (String)EnvVars.masterEnvVars.get(OPENSHIFT_ACCESS_VIA_BEARER_TOKEN);
                    if (enabled != null && enabled.equalsIgnoreCase("false") || (authHdr = httpRequest.getHeader("Authorization")) == null || authHdr.length() <= 0 || !authHdr.startsWith("Bearer") || (words = authHdr.split(" ")).length <= 1) break block17;
                    String token = words[1];
                    BearerCacheEntry entry = this.bearerCache.get(token);
                    if (entry == null) {
                        entry = new BearerCacheEntry();
                        this.bearerCache.put(token, entry);
                        entry.lastCheck = 0L;
                    }
                    if (updated || System.currentTimeMillis() - entry.lastCheck > interval * 1000L) {
                        UsernamePasswordAuthenticationToken jenkinsToken;
                        entry.lastCheck = new Long(System.currentTimeMillis());
                        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(token);
                        OpenShiftOAuth2SecurityRealm secRealm = (OpenShiftOAuth2SecurityRealm)Jenkins.getInstance().getSecurityRealm();
                        entry.token = jenkinsToken = secRealm.updateAuthorizationStrategy(credential);
                        break block17;
                    }
                    if (entry.token != null) {
                        SecurityContextHolder.getContext().setAuthentication((Authentication)entry.token);
                        break block17;
                    }
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.sendError(401, NEED_TO_AUTH);
                }
                catch (HttpResponseException e) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.sendError(e.getStatusCode(), e.getMessage() + NEED_TO_AUTH);
                }
                catch (Throwable t) {
                    OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.SEVERE, "filter", t);
                }
            }
            finally {
                chain.doFilter(request, response);
            }
        }
    }

    public void destroy() {
    }

    class BearerCacheEntry {
        long lastCheck;
        UsernamePasswordAuthenticationToken token;

        BearerCacheEntry() {
        }
    }
}

