/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;

@Extension
public class CounterRunListener
extends RunListener<AbstractBuild> {
    private static final Counter BUILD_COUNTER = new Counter("builds", "jobs.png");
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden((String)BUILD_COUNTER.getName());
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();

    public CounterRunListener() {
        super(AbstractBuild.class);
        BUILD_COUNTER.setDisplayed(!COUNTER_HIDDEN);
    }

    static Counter getBuildCounter() {
        return BUILD_COUNTER;
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
        super.onStarted((Run)r, listener);
        if (DISABLED || !BUILD_COUNTER.isDisplayed()) {
            return;
        }
        if (this.isMavenModuleBuild(r)) {
            return;
        }
        String name = r.getProject().getName();
        BUILD_COUNTER.bindContextIncludingCpu(name);
        JdbcWrapper.RUNNING_BUILD_COUNT.incrementAndGet();
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        super.onCompleted((Run)r, listener);
        if (DISABLED || !BUILD_COUNTER.isDisplayed()) {
            return;
        }
        if (this.isMavenModuleBuild(r)) {
            return;
        }
        JdbcWrapper.RUNNING_BUILD_COUNT.decrementAndGet();
        boolean error = Result.FAILURE.equals(r.getResult());
        BUILD_COUNTER.addRequestForCurrentContext(error);
    }

    private boolean isMavenModuleBuild(AbstractBuild r) {
        return "hudson.maven.MavenBuild".equals(r.getClass().getName());
    }
}

