/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.model.User;
import hudson.plugins.im.AuthenticationHolder;
import hudson.plugins.im.DummyConnection;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.tools.ExceptionHelper;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class IMConnectionProvider
implements IMConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(IMConnectionProvider.class.getName());
    private static final IMConnection NULL_CONNECTION = new DummyConnection();
    protected IMPublisherDescriptor descriptor;
    private IMConnection imConnection = NULL_CONNECTION;
    private Authentication authentication = null;
    private final ConnectorRunnable connector = new ConnectorRunnable();

    protected IMConnectionProvider() {
    }

    protected void init() {
        Thread connectorThread = new Thread((Runnable)this.connector, "IM-Reconnector-Thread");
        connectorThread.setDaemon(true);
        connectorThread.start();
        this.tryReconnect();
    }

    public abstract IMConnection createConnection() throws IMException;

    private synchronized boolean create() throws IMException {
        if (this.descriptor == null || !this.descriptor.isEnabled()) {
            this.imConnection = NULL_CONNECTION;
            return true;
        }
        try {
            this.imConnection = this.createConnection();
            this.imConnection.addConnectionListener(this);
            return true;
        }
        catch (IMException e) {
            LOGGER.log(Level.WARNING, "Could not create IM connection", e);
            this.imConnection = NULL_CONNECTION;
            this.tryReconnect();
            return false;
        }
    }

    public synchronized IMConnection currentConnection() {
        return this.imConnection;
    }

    public synchronized void releaseConnection() {
        if (this.imConnection != null) {
            this.imConnection.removeConnectionListener(this);
            this.imConnection.close();
            this.imConnection = NULL_CONNECTION;
        }
    }

    protected synchronized IMPublisherDescriptor getDescriptor() {
        return this.descriptor;
    }

    public synchronized void setDescriptor(IMPublisherDescriptor desc) {
        this.descriptor = desc;
        if (desc != null && desc.isEnabled()) {
            this.tryReconnect();
        }
    }

    @Override
    public void connectionBroken(Exception e) {
        this.tryReconnect();
    }

    private void tryReconnect() {
        this.connector.semaphore.release();
    }

    public synchronized AuthenticationHolder getAuthenticationHolder() {
        if (this.descriptor == null || this.descriptor.getHudsonUserName() == null) {
            return null;
        }
        return new AuthenticationHolder(){

            @Override
            public Authentication getAuthentication() {
                if (IMConnectionProvider.this.authentication != null) {
                    return IMConnectionProvider.this.authentication;
                }
                if (IMConnectionProvider.this.descriptor == null || IMConnectionProvider.this.descriptor.getHudsonUserName() == null) {
                    return null;
                }
                if (IMConnectionProvider.this.descriptor.getHudsonUserName().isBlank() && !Jenkins.getInstance().isUseSecurity()) {
                    return null;
                }
                try {
                    User u = User.get((String)IMConnectionProvider.this.descriptor.getHudsonUserName());
                    return u.impersonate2();
                }
                catch (UsernameNotFoundException ue) {
                    if (IMConnectionProvider.this.descriptor.getHudsonUserName().isBlank()) {
                        throw new UsernameNotFoundException("No local Jenkins user name is configured for instant messaging to act as");
                    }
                    throw ue;
                }
            }
        };
    }

    private final class ConnectorRunnable
    implements Runnable {
        private final Semaphore semaphore = new Semaphore(0);
        private boolean firstConnect = true;

        private ConnectorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block9: while (true) {
                    this.semaphore.acquire();
                    if (!this.firstConnect) {
                        TimeUnit.SECONDS.sleep(30L);
                        LOGGER.info("Trying to reconnect");
                    } else {
                        this.firstConnect = false;
                        LOGGER.info("Trying to connect");
                    }
                    boolean success = false;
                    int timeout = 1;
                    while (true) {
                        if (success) continue block9;
                        IMConnectionProvider iMConnectionProvider = IMConnectionProvider.this;
                        synchronized (iMConnectionProvider) {
                            if (IMConnectionProvider.this.imConnection != null) {
                                try {
                                    IMConnectionProvider.this.releaseConnection();
                                }
                                catch (Exception e) {
                                    LOGGER.warning(ExceptionHelper.dump(e));
                                }
                            }
                            try {
                                success = IMConnectionProvider.this.create();
                            }
                            catch (IMException iMException) {
                                // empty catch block
                            }
                        }
                        if (!success) {
                            LOGGER.info("Reconnect failed. Next connection attempt in " + timeout + " minutes");
                            this.semaphore.drainPermits();
                            boolean acquired = this.semaphore.tryAcquire((long)timeout * 60L, TimeUnit.SECONDS);
                            if (acquired) {
                                this.semaphore.release();
                            } else {
                                LOGGER.warning("Could not acquire semaphore for " + (long)timeout * 60L + "sec");
                            }
                            if (timeout >= 15) continue;
                            timeout *= 2;
                            continue;
                        }
                        this.semaphore.drainPermits();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Connect thread interrupted");
                return;
            }
        }
    }
}

