/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.build_notify;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.build_notify.BuildToChatNotifierDescriptor;
import hudson.plugins.im.build_notify.Messages;
import hudson.plugins.im.tools.BuildHelper;
import hudson.plugins.im.tools.MessageHelper;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SummaryOnlyBuildToChatNotifier
extends BuildToChatNotifier {
    @DataBoundConstructor
    public SummaryOnlyBuildToChatNotifier() {
    }

    @Override
    public String buildStartMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        return this.buildStartMessage(publisher, (Run<?, ?>)build, (TaskListener)listener);
    }

    @Override
    public String buildStartMessage(IMPublisher publisher, Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String extraMessage = publisher.getExtraMessage();
        if (extraMessage != null && !extraMessage.equals("")) {
            return Messages.SummaryOnlyBuildToChatNotifier_StartMessageExtra(build.getDisplayName(), BuildHelper.getProjectName(build), extraMessage);
        }
        return Messages.SummaryOnlyBuildToChatNotifier_StartMessage(build.getDisplayName(), BuildHelper.getProjectName(build));
    }

    @Override
    public String buildCompletionMessage(IMPublisher publisher, Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        StringBuilder sb = BuildHelper.isFix(run) ? new StringBuilder(Messages.SummaryOnlyBuildToChatNotifier_BuildIsFixed()) : new StringBuilder();
        ResultTrend result = BuildHelper.getResultTrend(run);
        String extraMessage = publisher.getExtraMessage();
        if (extraMessage != null && !extraMessage.equals("")) {
            sb.append(Messages.SummaryOnlyBuildToChatNotifier_SummaryExtra(BuildHelper.getProjectName(run), run.getDisplayName(), result.getID(), run.getTimestampString(), MessageHelper.getBuildURL(run), extraMessage));
        } else {
            sb.append(Messages.SummaryOnlyBuildToChatNotifier_Summary(BuildHelper.getProjectName(run), run.getDisplayName(), result.getID(), run.getTimestampString(), MessageHelper.getBuildURL(run)));
        }
        return sb.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildToChatNotifierDescriptor {
        @Override
        public String getDisplayName() {
            return "Just summary";
        }
    }
}

