/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Fingerprint;
import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.im.DummyConnection;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.build_notify.DefaultBuildToChatNotifier;
import hudson.plugins.im.tools.BuildHelper;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundSetter;
import org.springframework.util.Assert;

public abstract class IMPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(IMPublisher.class.getName());
    private List<IMMessageTarget> targets;
    @Deprecated
    private hudson.plugins.jabber.NotificationStrategy notificationStrategy;
    private NotificationStrategy strategy;
    private final boolean notifyOnBuildStart;
    private final boolean notifySuspects;
    private final boolean notifyCulprits;
    private final boolean notifyFixers;
    private final boolean notifyUpstreamCommitters;
    private BuildToChatNotifier buildToChatNotifier;
    private MatrixJobMultiplier matrixMultiplier = MatrixJobMultiplier.ONLY_CONFIGURATIONS;
    private String extraMessage = "";
    private String customMessage = "";
    @Deprecated
    private transient String defaultIdSuffix;

    @Deprecated
    protected IMPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters) {
        this(defaultTargets, notificationStrategyString, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, new DefaultBuildToChatNotifier(), MatrixJobMultiplier.ALL);
    }

    protected IMPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier, MatrixJobMultiplier matrixMultiplier) {
        this.targets = defaultTargets != null ? defaultTargets : Collections.emptyList();
        NotificationStrategy strategy = NotificationStrategy.forDisplayName(notificationStrategyString);
        if (strategy == null) {
            strategy = NotificationStrategy.STATECHANGE_ONLY;
        }
        this.strategy = strategy;
        this.notifyOnBuildStart = notifyGroupChatsOnBuildStart;
        this.notifySuspects = notifySuspects;
        this.notifyCulprits = notifyCulprits;
        this.notifyFixers = notifyFixers;
        this.notifyUpstreamCommitters = notifyUpstreamCommitters;
        if (buildToChatNotifier == null) {
            buildToChatNotifier = new DefaultBuildToChatNotifier();
        }
        this.buildToChatNotifier = buildToChatNotifier;
        this.matrixMultiplier = matrixMultiplier;
    }

    public boolean needsToRunAfterFinalized() {
        return this.notifyUpstreamCommitters;
    }

    protected abstract String getPluginName();

    protected abstract IMConnection getIMConnection() throws IMException;

    protected NotificationStrategy getNotificationStrategy() {
        return this.strategy;
    }

    protected void setNotificationStrategy(NotificationStrategy strategy) {
        this.strategy = strategy;
    }

    public BuildToChatNotifier getBuildToChatNotifier() {
        return this.buildToChatNotifier;
    }

    public List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    protected List<IMMessageTarget> calculateTargets() {
        if (this.getNotificationTargets() != null && this.getNotificationTargets().size() > 0) {
            return this.getNotificationTargets();
        }
        return ((IMPublisherDescriptor)this.getDescriptor()).getDefaultTargets();
    }

    public String getTargets() {
        if (this.targets == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget t : this.targets) {
            sb.append(this.getIMDescriptor().getIMMessageTargetConverter().toString(t));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    @Deprecated
    protected void setTargets(String targetsAsString) throws IMMessageTargetConversionException {
        this.targets = new LinkedList<IMMessageTarget>();
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMDescriptor().getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
    }

    @Deprecated
    protected void setNotificationTargets(List<IMMessageTarget> targets) {
        this.targets = targets != null ? targets : Collections.emptyList();
    }

    public final String getStrategy() {
        return this.getNotificationStrategy().getDisplayName();
    }

    public boolean getNotifyOnStart() {
        return this.notifyOnBuildStart;
    }

    public final boolean getNotifySuspects() {
        return this.notifySuspects;
    }

    public final boolean getNotifyCulprits() {
        return this.notifyCulprits;
    }

    public final boolean getNotifyFixers() {
        return this.notifyFixers;
    }

    public final boolean getNotifyUpstreamCommitters() {
        return this.notifyUpstreamCommitters;
    }

    public String getExtraMessage() {
        return this.extraMessage;
    }

    @DataBoundSetter
    public void setExtraMessage(String extraMessage) {
        if (extraMessage == null) {
            extraMessage = "";
        }
        this.extraMessage = extraMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(String customMessage) {
        if (customMessage == null) {
            customMessage = "";
        }
        this.customMessage = customMessage;
    }

    protected void log(TaskListener listener, String message) {
        listener.getLogger().append(this.getPluginName()).append(": ").append(message).append("\n");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        this.internalPerform((Run<?, ?>)build, launcher, (TaskListener)buildListener);
        return true;
    }

    private void internalPerform(@NonNull Run<?, ?> run, @NonNull Launcher launcher, @NonNull TaskListener taskListener) throws InterruptedException, IOException {
        if (this.customMessage == null || this.customMessage.isEmpty()) {
            Assert.notNull(run, (String)"Parameter 'build' must not be null.");
            Assert.notNull((Object)taskListener, (String)"Parameter 'buildListener' must not be null.");
            if (run.getParent() instanceof MatrixConfiguration) {
                if (this.getMatrixNotifier() == MatrixJobMultiplier.ONLY_CONFIGURATIONS || this.getMatrixNotifier() == MatrixJobMultiplier.ALL) {
                    this.notifyOnBuildEnd(run, taskListener);
                }
            } else {
                if (run.getParent() instanceof WorkflowJob && this.getNotifyOnStart()) {
                    this.notifyChatsOnBuildStart(run, taskListener);
                    return;
                }
                this.notifyOnBuildEnd(run, taskListener);
            }
        } else {
            try {
                for (IMMessageTarget target : this.targets) {
                    try {
                        this.log(taskListener, "Sending custom message to target: " + target.toString());
                        this.sendNotification(this.customMessage, target, taskListener);
                    }
                    catch (RuntimeException re) {
                        this.log(taskListener, "There was an error sending custom message to target: " + target.toString());
                    }
                }
            }
            catch (RuntimeException e) {
                this.log(taskListener, "There was an error iterating targets for sending a custom message");
            }
        }
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener taskListener) throws InterruptedException, IOException {
        this.log(taskListener, "IMPublisher: sending chat message, strategy " + String.valueOf((Object)this.strategy) + ", targets: " + this.getTargets());
        this.internalPerform(run, launcher, taskListener);
    }

    void notifyOnBuildEnd(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        ResultTrend resultTrend;
        if (this.getNotificationStrategy().notificationWanted(run)) {
            this.notifyChatsOnBuildEnd(run, listener);
        }
        if ((resultTrend = BuildHelper.getResultTrend(run)) == ResultTrend.STILL_FAILING || resultTrend == ResultTrend.STILL_UNSTABLE || resultTrend == ResultTrend.NOW_UNSTABLE) {
            String message;
            if (this.notifySuspects) {
                this.log(listener, "Notifying suspects");
                message = this.getBuildToChatNotifier().suspectMessage(this, run, listener, false);
                for (IMMessageTarget iMMessageTarget : this.calculateIMTargets(BuildHelper.getCommitters(run, listener), listener)) {
                    try {
                        this.log(listener, "Sending notification to suspect: " + iMMessageTarget.toString());
                        this.sendNotification(message, iMMessageTarget, listener);
                    }
                    catch (RuntimeException e) {
                        this.log(listener, "There was an error sending suspect notification to: " + iMMessageTarget.toString());
                    }
                }
            }
            if (this.notifyCulprits) {
                this.log(listener, "Notifying culprits");
                message = this.getBuildToChatNotifier().culpritMessage(this, run, listener);
                for (IMMessageTarget iMMessageTarget : this.calculateIMTargets(IMPublisher.getCulpritsOnly(run, listener), listener)) {
                    try {
                        this.log(listener, "Sending notification to culprit: " + iMMessageTarget.toString());
                        this.sendNotification(message, iMMessageTarget, listener);
                    }
                    catch (RuntimeException e) {
                        this.log(listener, "There was an error sending culprit notification to: " + iMMessageTarget.toString());
                    }
                }
            }
        } else if (resultTrend == ResultTrend.FAILURE || resultTrend == ResultTrend.UNSTABLE) {
            boolean committerNotified = false;
            if (this.notifySuspects) {
                this.log(listener, "Notifying suspects");
                String message = this.getBuildToChatNotifier().suspectMessage(this, run, listener, true);
                for (IMMessageTarget target : this.calculateIMTargets(BuildHelper.getCommitters(run, listener), listener)) {
                    try {
                        this.log(listener, "Sending notification to suspect: " + target.toString());
                        this.sendNotification(message, target, listener);
                        committerNotified = true;
                    }
                    catch (RuntimeException e) {
                        this.log(listener, "There was an error sending suspect notification to: " + target.toString());
                    }
                }
            }
            if (this.notifyUpstreamCommitters && !committerNotified) {
                this.notifyUpstreamCommitters(run, listener);
            }
        }
        if (this.notifyFixers && resultTrend == ResultTrend.FIXED) {
            this.log(listener, "Notifying fixers");
            String message = this.getBuildToChatNotifier().fixerMessage(this, run, listener);
            for (IMMessageTarget iMMessageTarget : this.calculateIMTargets(BuildHelper.getCommitters(run, listener), listener)) {
                try {
                    this.log(listener, "Sending notification to fixer: " + iMMessageTarget.toString());
                    this.sendNotification(message, iMMessageTarget, listener);
                }
                catch (RuntimeException e) {
                    this.log(listener, "There was an error sending fixer notification to: " + iMMessageTarget.toString());
                }
            }
        }
    }

    private void sendNotification(String message, IMMessageTarget target, TaskListener listener) throws IMException {
        IMConnection imConnection = this.getIMConnection();
        if (imConnection instanceof DummyConnection) {
            this.log(listener, "[ERROR] not connected. Cannot send message to '" + String.valueOf(target) + "'");
        } else {
            this.getIMConnection().send(target, message);
        }
    }

    private void notifyUpstreamCommitters(Run<?, ?> run, TaskListener listener) {
        Map<User, AbstractBuild<?, ?>> committers = this.getNearestUpstreamCommitters(run, listener);
        for (Map.Entry<User, AbstractBuild<?, ?>> entry : committers.entrySet()) {
            String message = this.getBuildToChatNotifier().upstreamCommitterMessage(this, run, listener, (Run)entry.getValue());
            IMMessageTarget target = this.calculateIMTarget(entry.getKey(), listener);
            try {
                this.log(listener, "Sending notification to upstream committer: " + target.toString());
                this.sendNotification(message, target, listener);
            }
            catch (IMException e) {
                this.log(listener, "There was an error sending upstream committer notification to: " + target.toString());
            }
        }
    }

    Map<User, AbstractBuild<?, ?>> getNearestUpstreamCommitters(Run<?, ?> run, TaskListener listener) {
        if (!(run instanceof AbstractBuild)) {
            return Collections.emptyMap();
        }
        Map<AbstractProject, List<AbstractBuild>> upstreamBuilds = this.getUpstreamBuildsSinceLastStable(run);
        HashMap upstreamCommitters = new HashMap();
        while (upstreamCommitters.isEmpty() && !upstreamBuilds.isEmpty()) {
            Map<AbstractProject, List<AbstractBuild>> currentLevel = upstreamBuilds;
            upstreamBuilds = new HashMap<AbstractProject, List<AbstractBuild>>();
            for (Map.Entry<AbstractProject, List<AbstractBuild>> entry : currentLevel.entrySet()) {
                List<AbstractBuild> upstreams = entry.getValue();
                for (AbstractBuild upstreamBuild : upstreams) {
                    if (upstreamBuild == null || !this.downstreamIsFirstInRangeTriggeredByUpstream(upstreamBuild, (AbstractBuild)run)) continue;
                    Set<User> committers = BuildHelper.getCommitters(upstreamBuild, listener);
                    for (User committer : committers) {
                        upstreamCommitters.put(committer, upstreamBuild);
                    }
                    upstreamBuilds.putAll(this.getUpstreamBuildsSinceLastStable((Run<?, ?>)upstreamBuild));
                }
            }
        }
        return upstreamCommitters;
    }

    private Map<AbstractProject, List<AbstractBuild>> getUpstreamBuildsSinceLastStable(Run<?, ?> run) {
        Run previousSuccessfulBuild = run.getPreviousSuccessfulBuild();
        if (previousSuccessfulBuild == null) {
            return Collections.emptyMap();
        }
        HashMap<AbstractProject, List<AbstractBuild>> result = new HashMap<AbstractProject, List<AbstractBuild>>();
        if (run instanceof AbstractBuild) {
            AbstractBuild currentBuild = (AbstractBuild)run;
            Set upstreamProjects = currentBuild.getUpstreamBuilds().keySet();
            for (AbstractProject upstreamProject : upstreamProjects) {
                result.put(upstreamProject, this.getUpstreamBuilds(upstreamProject, (AbstractBuild)previousSuccessfulBuild, currentBuild));
            }
        } else {
            return Collections.emptyMap();
        }
        return result;
    }

    private List<AbstractBuild> getUpstreamBuilds(AbstractProject upstreamProject, AbstractBuild<?, ?> sinceBuild, AbstractBuild<?, ?> untilBuild) {
        ArrayList result = Lists.newArrayList();
        AbstractBuild sinceBuildUpstreamBuild = sinceBuild.getUpstreamRelationshipBuild(upstreamProject);
        AbstractBuild untilBuildUpstreamBuild = untilBuild.getUpstreamRelationshipBuild(upstreamProject);
        AbstractBuild build = sinceBuildUpstreamBuild;
        if (build == null) {
            return result;
        }
        do {
            if ((build = build.getNextBuild()) == null) continue;
            result.add(build);
        } while (build != untilBuildUpstreamBuild && build != null);
        return result;
    }

    private boolean downstreamIsFirstInRangeTriggeredByUpstream(AbstractBuild<?, ?> upstreamBuild, AbstractBuild<?, ?> downstreamBuild) {
        AbstractProject downstreamProject = downstreamBuild.getProject();
        Fingerprint.RangeSet rangeSet = upstreamBuild.getDownstreamRelationship(downstreamProject);
        if (rangeSet == null || rangeSet.isEmpty()) {
            LOGGER.warning("Range set is empty. Upstream " + String.valueOf(upstreamBuild) + ", downstream " + String.valueOf(downstreamBuild));
            return false;
        }
        return rangeSet.min() == downstreamBuild.getNumber();
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener buildListener) {
        try {
            if (this.getNotifyOnStart()) {
                if (build.getProject() instanceof MatrixConfiguration) {
                    if (this.getMatrixNotifier() == MatrixJobMultiplier.ONLY_CONFIGURATIONS || this.getMatrixNotifier() == MatrixJobMultiplier.ALL) {
                        this.notifyChatsOnBuildStart(build, buildListener);
                    }
                } else {
                    this.notifyChatsOnBuildStart(build, buildListener);
                }
            }
        }
        catch (IOException e) {
            this.log((TaskListener)buildListener, "[ERROR] in " + this.getPluginName() + " plugin: " + ExceptionHelper.dump(e));
        }
        catch (InterruptedException e) {
            this.log((TaskListener)buildListener, "[ERROR] in " + this.getPluginName() + " plugin: " + ExceptionHelper.dump(e));
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            this.log((TaskListener)buildListener, "[ERROR] in " + this.getPluginName() + " plugin: " + ExceptionHelper.dump(e));
        }
        return true;
    }

    void notifyChatsOnBuildStart(AbstractBuild<?, ?> build, BuildListener buildListener) throws IOException, InterruptedException {
        this.notifyChatsOnBuildStart((Run<?, ?>)build, (TaskListener)buildListener);
    }

    void notifyChatsOnBuildStart(@NonNull Run<?, ?> build, @NonNull TaskListener buildListener) throws IOException, InterruptedException {
        String msg = this.getBuildToChatNotifier().buildStartMessage(this, build, buildListener);
        if (Util.fixEmpty((String)msg) == null) {
            return;
        }
        for (IMMessageTarget target : this.calculateTargets()) {
            if (!(target instanceof GroupChatIMMessageTarget)) continue;
            try {
                this.sendNotification(msg, target, buildListener);
            }
            catch (IMException e) {
                this.log(buildListener, "There was an error sending notification to: " + target.toString());
            }
        }
    }

    private void notifyChatsOnBuildEnd(Run<?, ?> run, TaskListener buildListener) throws IOException, InterruptedException {
        String msg = this.buildToChatNotifier.buildCompletionMessage(this, run, buildListener);
        if (Util.fixEmpty((String)msg) == null) {
            return;
        }
        for (IMMessageTarget target : this.calculateTargets()) {
            try {
                this.log(buildListener, "Sending notification to: " + target.toString());
                this.sendNotification(msg, target, buildListener);
            }
            catch (RuntimeException t) {
                this.log(buildListener, "There was an error sending notification to: " + target.toString() + "\n" + ExceptionHelper.dump(t));
            }
        }
    }

    private static Set<User> getCulpritsOnly(Run<?, ?> run, TaskListener listener) {
        Set c = null;
        if (run instanceof AbstractBuild) {
            c = ((AbstractBuild)run).getCulprits();
        } else {
            try {
                Method getCulprits = run.getClass().getMethod("getCulprits", new Class[0]);
                c = (Set)getCulprits.invoke(run, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                listener.error("Failed to invoke getCulprits() method, cannot get culprits: " + String.valueOf(run.getClass()), new Object[]{e});
            }
        }
        HashSet<User> culprits = c == null ? new HashSet<User>() : new HashSet(c);
        culprits.removeAll(BuildHelper.getCommitters(run, listener));
        return culprits;
    }

    private Collection<IMMessageTarget> calculateIMTargets(Set<User> targets, TaskListener listener) {
        HashSet<IMMessageTarget> suspects = new HashSet<IMMessageTarget>();
        String defaultIdSuffix = ((IMPublisherDescriptor)this.getDescriptor()).getDefaultIdSuffix();
        LOGGER.fine("Default Suffix: " + defaultIdSuffix);
        for (User target : targets) {
            IMMessageTarget imTarget = this.calculateIMTarget(target, listener);
            if (imTarget == null) continue;
            suspects.add(imTarget);
        }
        return suspects;
    }

    private IMMessageTarget calculateIMTarget(User target, TaskListener listener) {
        String defaultIdSuffix = ((IMPublisherDescriptor)this.getDescriptor()).getDefaultIdSuffix();
        LOGGER.fine("Possible target: " + target.getId());
        Object imId = this.getConfiguredIMId(target);
        if (imId == null && defaultIdSuffix != null) {
            imId = target.getId() + defaultIdSuffix;
        }
        if (imId != null) {
            try {
                return this.getIMDescriptor().getIMMessageTargetConverter().fromString((String)imId);
            }
            catch (IMMessageTargetConversionException e) {
                this.log(listener, "Invalid IM ID: " + (String)imId);
            }
        } else {
            this.log(listener, "No IM ID found for: " + target.getId());
        }
        return null;
    }

    public abstract BuildStepDescriptor<Publisher> getDescriptor();

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected Object readResolve() {
        if (this.strategy == null && this.notificationStrategy != null) {
            this.strategy = NotificationStrategy.valueOf(this.notificationStrategy.name());
            this.notificationStrategy = null;
        }
        if (this.buildToChatNotifier == null) {
            this.buildToChatNotifier = new DefaultBuildToChatNotifier();
        }
        if (this.matrixMultiplier == null) {
            this.matrixMultiplier = MatrixJobMultiplier.ONLY_CONFIGURATIONS;
        }
        return this;
    }

    protected final IMPublisherDescriptor getIMDescriptor() {
        return (IMPublisherDescriptor)this.getDescriptor();
    }

    protected abstract String getConfiguredIMId(User var1);

    public MatrixJobMultiplier getMatrixNotifier() {
        return this.matrixMultiplier;
    }

    public void setMatrixNotifier(MatrixJobMultiplier matrixMultiplier) {
        this.matrixMultiplier = matrixMultiplier;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean startBuild() throws InterruptedException, IOException {
                if (IMPublisher.this.getNotifyOnStart() && (IMPublisher.this.getMatrixNotifier() == MatrixJobMultiplier.ALL || IMPublisher.this.getMatrixNotifier() == MatrixJobMultiplier.ONLY_PARENT)) {
                    IMPublisher.this.notifyChatsOnBuildStart((AbstractBuild<?, ?>)this.build, this.listener);
                }
                return super.startBuild();
            }

            public boolean endBuild() throws InterruptedException, IOException {
                if (IMPublisher.this.getMatrixNotifier() == MatrixJobMultiplier.ALL || IMPublisher.this.getMatrixNotifier() == MatrixJobMultiplier.ONLY_PARENT) {
                    IMPublisher.this.notifyOnBuildEnd((Run<?, ?>)this.build, (TaskListener)this.listener);
                }
                return super.endBuild();
            }
        };
    }

    public boolean isMatrixProject(AbstractProject<?, ?> project) {
        return project instanceof MatrixProject;
    }
}

