/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.project;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import hudson.plugins.favorite.Messages;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.jenkins.ui.icon.IconSpec;

public class FavoriteProjectAction
implements Action,
IconSpec {
    private final TopLevelItem topLevelItem;

    public FavoriteProjectAction(TopLevelItem topLevelItem) {
        this.topLevelItem = topLevelItem;
    }

    public String getItemName() {
        return this.topLevelItem.getFullName();
    }

    @Deprecated
    public String getProjectName() {
        return this.getItemName();
    }

    public String getIconFileName() {
        return null;
    }

    public String getIconClassName() {
        if (this.hasPermission()) {
            return this.isFavorite() ? "symbol-star plugin-ionicons-api" : "symbol-star-outline plugin-ionicons-api";
        }
        return null;
    }

    public String getDisplayName() {
        if (this.hasPermission()) {
            return Messages.favoriteColumn();
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission()) {
            return "plugin/favorite/toggleFavorite?job=" + URLEncoder.encode(this.getItemName(), StandardCharsets.UTF_8) + "&redirect=true";
        }
        return null;
    }

    private boolean hasPermission() {
        return User.current() != null;
    }

    public boolean isFavorite() {
        User user = User.current();
        return user != null && Favorites.isFavorite(user, (Item)this.topLevelItem);
    }
}

