/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.column;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.plugins.favorite.Messages;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class FavoriteColumn
extends ListViewColumn {
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public FavoriteColumn() {
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean isFavorite(String job) {
        FavoriteUserProperty fup = this.getFavoriteUserProperty();
        return fup != null && fup.isJobFavorite(job);
    }

    private FavoriteUserProperty getFavoriteUserProperty() {
        User user = User.current();
        if (user == null) {
            return null;
        }
        return (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
    }

    public int getSortData(String job) {
        FavoriteUserProperty fup = this.getFavoriteUserProperty();
        if (fup == null || !fup.isJobFavorite(job)) {
            return 0;
        }
        return 1;
    }

    private static class DescriptorImpl
    extends ListViewColumnDescriptor {
        private DescriptorImpl() {
        }

        public ListViewColumn newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return new FavoriteColumn();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.favoriteColumn();
        }

        public boolean shownByDefault() {
            return User.current() != null;
        }
    }
}

