/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.favorite.user.FavoriteUserPropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class FavoriteUserProperty
extends UserProperty
implements Action {
    private static final Logger LOGGER = Logger.getLogger(FavoriteUserProperty.class.getName());
    @Extension
    public static final UserPropertyDescriptor DESCRIPTOR = new FavoriteUserPropertyDescriptor();
    transient List<String> favorites = new ArrayList<String>();
    private ConcurrentMap<String, Boolean> data = new ConcurrentHashMap<String, Boolean>();
    private transient long lastValidated = 0L;

    @DataBoundConstructor
    public FavoriteUserProperty() {
    }

    public User getUser() {
        return this.user;
    }

    @Deprecated
    public List<String> getFavorites() {
        this.removeFavoritesWhichDoNotExist();
        return this.data.entrySet().stream().filter(input -> input != null && (Boolean)input.getValue() != false).map(Map.Entry::getKey).toList();
    }

    @Restricted(value={NoExternalUse.class})
    public List<Item> getFavoritesSortedByDisplayName() {
        Jenkins jenkins = Jenkins.get();
        return this.getAllFavorites().stream().map(arg_0 -> ((Jenkins)jenkins).getItemByFullName(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparing(Item::getFullDisplayName, String.CASE_INSENSITIVE_ORDER)).toList();
    }

    public Set<String> getAllFavorites() {
        this.removeFavoritesWhichDoNotExist();
        return Maps.filterEntries(this.data, input -> input != null && (Boolean)input.getValue() != false).keySet();
    }

    public void addFavorite(@NonNull String job) throws IOException {
        this.data.put(job, true);
        this.user.save();
    }

    public void removeFavorite(@NonNull String job) throws IOException {
        this.data.put(job, false);
        this.user.save();
    }

    public boolean toggleFavorite(@NonNull String job) throws IOException {
        if (this.isJobFavorite(job)) {
            this.removeFavorite(job);
            return false;
        }
        this.addFavorite(job);
        return true;
    }

    void deleteFavourite(@NonNull String job) throws IOException {
        this.data.remove(job);
        this.user.save();
    }

    public UserProperty reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    public boolean isJobFavorite(String job) {
        Boolean favorite = (Boolean)this.data.get(job);
        return favorite != null ? favorite : false;
    }

    public boolean hasFavorite(String job) {
        return this.data.containsKey(job);
    }

    public UserPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    Object readResolve() {
        if (this.favorites != null) {
            this.data = new ConcurrentHashMap<String, Boolean>();
            for (String job : this.favorites) {
                this.data.put(job, true);
            }
            this.favorites = null;
        }
        return this;
    }

    private void removeFavoritesWhichDoNotExist() {
        Jenkins jenkins = Jenkins.get();
        for (String fullName : Collections.unmodifiableSet(this.data.keySet())) {
            if (jenkins.getItemByFullName(fullName) != null) continue;
            try {
                this.deleteFavourite(fullName);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not purge favorite '" + fullName + "'", e);
            }
        }
    }

    public String getIconFileName() {
        return "symbol-star plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Favorites";
    }

    public String getUrlName() {
        return "favorites";
    }
}

