/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.extendedread;

import hudson.security.Permission;
import hudson.util.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public class SystemReadPermission {
    private static final Logger LOGGER;
    public static final Permission SYSTEM_READ;

    static {
        Permission systemRead;
        LOGGER = Logger.getLogger(SystemReadPermission.class.getName());
        try {
            systemRead = (Permission)ReflectionUtils.getPublicProperty((Object)Jenkins.get(), (String)"SYSTEM_READ");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.log(Level.FINE, "Couldn't find system read permission, falling back to ADMINISTER", e);
            systemRead = Jenkins.ADMINISTER;
        }
        SYSTEM_READ = systemRead;
    }
}

