/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.agent;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.withscript.WithScriptDescriptor;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;

public abstract class DeclarativeAgentDescriptor<A extends DeclarativeAgent<A>>
extends WithScriptDescriptor<A> {
    public static ExtensionList<DeclarativeAgentDescriptor> all() {
        return ExtensionList.lookup(DeclarativeAgentDescriptor.class);
    }

    public static List<DeclarativeAgentDescriptor> allSorted() {
        return DeclarativeAgentDescriptor.all().stream().sorted(Comparator.comparing(WithScriptDescriptor::getName)).collect(Collectors.toList());
    }

    public static Map<String, DescribableModel> getDescribableModels() {
        HashMap<String, DescribableModel> models = new HashMap<String, DescribableModel>();
        for (DeclarativeAgentDescriptor d : DeclarativeAgentDescriptor.all()) {
            for (String s : SymbolLookup.getSymbolValue((Object)((Object)d))) {
                models.put(s, new DescribableModel(d.clazz));
            }
        }
        return models;
    }

    public static Map<String, DescribableModel> zeroArgModels() {
        HashMap<String, DescribableModel> models = new HashMap<String, DescribableModel>();
        for (Map.Entry<String, DescribableModel> entry : DeclarativeAgentDescriptor.getDescribableModels().entrySet()) {
            if (!entry.getValue().getParameters().isEmpty()) continue;
            models.put(entry.getKey(), entry.getValue());
        }
        return models;
    }

    public static Map<String, DescribableModel> noRequiredArgsModels() {
        HashMap<String, DescribableModel> models = new HashMap<String, DescribableModel>();
        for (Map.Entry<String, DescribableModel> entry : DeclarativeAgentDescriptor.getDescribableModels().entrySet()) {
            if (entry.getValue().getFirstRequiredParameter() != null) continue;
            models.put(entry.getKey(), entry.getValue());
        }
        return models;
    }

    @Nullable
    public static DeclarativeAgentDescriptor byName(@NonNull String name) {
        return (DeclarativeAgentDescriptor)SymbolLookup.get().findDescriptor(DeclarativeAgent.class, name);
    }

    @Nullable
    public static DeclarativeAgent<?> instanceForName(@NonNull String name, Map<String, Object> arguments) throws Exception {
        DeclarativeAgentDescriptor descriptor = DeclarativeAgentDescriptor.byName(name);
        if (descriptor != null) {
            return DeclarativeAgentDescriptor.instanceForDescriptor(descriptor, arguments);
        }
        return null;
    }

    @NonNull
    public static DeclarativeAgent<?> instanceForDescriptor(@NonNull DeclarativeAgentDescriptor<?> descriptor, Map<String, Object> arguments) throws Exception {
        if (DeclarativeAgentDescriptor.zeroArgModels().keySet().contains(descriptor.getName()) || DeclarativeAgentDescriptor.noRequiredArgsModels().keySet().contains(descriptor.getName()) && arguments.containsKey("<anonymous>") && arguments.size() == 1) {
            return (DeclarativeAgent)descriptor.newInstance();
        }
        return (DeclarativeAgent)descriptor.newInstance(arguments);
    }
}

