/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.agent;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionPoint;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentScript;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentScript2;
import org.jenkinsci.plugins.pipeline.modeldefinition.options.DeclarativeOption;
import org.jenkinsci.plugins.pipeline.modeldefinition.withscript.WithScriptDescribable;
import org.jenkinsci.plugins.pipeline.modeldefinition.withscript.WithScriptScript;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.GroovySourceFileAllowlist;

public abstract class DeclarativeAgent<A extends DeclarativeAgent<A>>
extends WithScriptDescribable<A>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(DeclarativeAgent.class.getName());
    protected boolean inStage;
    protected boolean doCheckout;
    protected String subdirectory;

    @Override
    public WithScriptScript getScript(CpsScript cpsScript) throws Exception {
        CpsThread c = CpsThread.current();
        if (c == null) {
            throw new IllegalStateException("Expected to be called from CpsThread");
        }
        cpsScript.getClass().getClassLoader().loadClass("org.jenkinsci.plugins.pipeline.modeldefinition.agent.CheckoutScript");
        WithScriptScript script = super.getScript(cpsScript);
        if (script instanceof DeclarativeAgentScript) {
            LOGGER.warning(() -> script.getClass().getName() + " should implement " + DeclarativeAgentScript2.class.getName());
        }
        return script;
    }

    public void setInStage(boolean inStage) {
        this.inStage = inStage;
    }

    public boolean isInStage() {
        return this.inStage;
    }

    public void initialize(Map<String, DeclarativeOption> options, boolean explicitAgentInStage) {
    }

    public boolean reuseRootAgent(Map<String, DeclarativeOption> options) {
        return false;
    }

    public void setDoCheckout(boolean doCheckout) {
        this.doCheckout = doCheckout;
    }

    public boolean isDoCheckout() {
        return this.doCheckout;
    }

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public void copyFlags(@NonNull DeclarativeAgent a) {
        this.setInStage(a.isInStage());
        this.setDoCheckout(a.isDoCheckout());
        this.setSubdirectory(a.getSubdirectory());
    }

    public boolean hasScmContext(CpsScript script) {
        try {
            script.getProperty("scm");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public DeclarativeAgentDescriptor getDescriptor() {
        return (DeclarativeAgentDescriptor)super.getDescriptor();
    }

    @Extension
    public static class CheckoutScriptAllowlist
    extends GroovySourceFileAllowlist {
        private final String scriptUrl = DeclarativeAgent.class.getResource("CheckoutScript.groovy").toString();

        public boolean isAllowed(String groovyResourceUrl) {
            return groovyResourceUrl.equals(this.scriptUrl);
        }
    }
}

