/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public final class MetricValue {
    private final String name;
    private final double value;
    private final String unit;

    @JsonCreator
    MetricValue(@JsonProperty(value="name") String name, @JsonProperty(value="value") double value, @JsonProperty(value="unit") String unit) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.value = (Double)Preconditions.checkNotNull((Object)value);
        this.unit = (String)Preconditions.checkNotNull((Object)unit);
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricValue)) {
            return false;
        }
        MetricValue other = (MetricValue)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }

    public String toString() {
        return "MetricValue(name=" + this.getName() + ", value=" + this.getValue() + ", unit=" + this.getUnit() + ")";
    }
}

