/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.emailext_template;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.security.Permission;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.emailext_template.ExtendedEmailPublisherTemplate;
import org.jenkinsci.plugins.emailext_template.ExtendedEmailTemplatePublisher;
import org.jenkinsci.plugins.emailext_template.Messages;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ExtEmailTemplateManagement
extends ManagementLink {
    public String getIconFileName() {
        return "symbol-mail-open-outline plugin-ionicons-api";
    }

    public String getUrlName() {
        return "emailexttemplates";
    }

    public String getDisplayName() {
        return Messages.ExtEmailTemplateManagement_DisplayName();
    }

    public String getDescription() {
        return Messages.ExtEmailTemplateManagement_Description();
    }

    public void doAddTemplate(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.checkPermission(Jenkins.ADMINISTER);
        ExtendedEmailPublisherTemplate template = new ExtendedEmailPublisherTemplate();
        req.setAttribute("template", (Object)template);
        req.getView((Object)this, "edit").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doEditTemplate(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="id") String templateId) throws IOException, ServletException {
        this.checkPermission(Jenkins.ADMINISTER);
        ExtendedEmailTemplatePublisher.DescriptorImpl descriptor = this.getPublisherDescriptor();
        ExtendedEmailPublisherTemplate template = descriptor.getTemplateById(templateId);
        if (template != null) {
            req.setAttribute("template", (Object)template);
            req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        } else {
            req.getView((Object)this, "index").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    @RequirePOST
    public HttpResponse doRemoveTemplate(StaplerRequest2 res, StaplerResponse2 rsp, @QueryParameter(value="id") String templateId) {
        this.checkPermission(Jenkins.ADMINISTER);
        ExtendedEmailTemplatePublisher.DescriptorImpl descriptor = this.getPublisherDescriptor();
        descriptor.removeTemplateById(templateId);
        return new HttpRedirect("index");
    }

    @RequirePOST
    public HttpResponse doSaveTemplate(StaplerRequest2 req) {
        this.checkPermission(Jenkins.ADMINISTER);
        try {
            ExtendedEmailTemplatePublisher.DescriptorImpl descriptor = this.getPublisherDescriptor();
            JSONObject json = req.getSubmittedForm().getJSONObject("template");
            String id = json.getString("id");
            ExtendedEmailPublisherTemplate template = descriptor.getTemplateById(id);
            if (template != null) {
                req.bindJSON((Object)template, json);
                template.setPublisher((ExtendedEmailPublisher)req.bindJSON(ExtendedEmailPublisher.class, json));
                descriptor.save();
            } else {
                template = (ExtendedEmailPublisherTemplate)req.bindJSON(ExtendedEmailPublisherTemplate.class, json);
                template.setPublisher((ExtendedEmailPublisher)req.bindJSON(ExtendedEmailPublisher.class, json));
                descriptor.addTemplate(template);
            }
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        return new HttpRedirect("index");
    }

    private ExtendedEmailTemplatePublisher.DescriptorImpl getPublisherDescriptor() {
        return (ExtendedEmailTemplatePublisher.DescriptorImpl)Jenkins.get().getDescriptorByType(ExtendedEmailTemplatePublisher.DescriptorImpl.class);
    }

    private void checkPermission(Permission permission) {
        Jenkins.get().checkPermission(permission);
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }
}

