/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="test-runtime", requiresDependencyResolution=ResolutionScope.TEST)
public class TestRuntimeMojo
extends AbstractJenkinsMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.build.directory}/patch-modules")
    private File patchModuleDir;

    public void execute() throws MojoExecutionException {
        if (this.skipTests || this.skip) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        this.setAddOpensProperty(this.resolveJenkinsWar());
        this.setInsaneHookProperty();
        this.setJavaAgentProperty();
    }

    @NonNull
    private Artifact resolveJenkinsWar() throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifact("org.jenkins-ci.main", "jenkins-war", this.findJenkinsVersion(), null, "war");
        return MavenArtifact.resolveArtifact(artifact, this.project, this.session, this.repositorySystem);
    }

    private void setInsaneHookProperty() throws MojoExecutionException {
        Artifact insane = (Artifact)this.project.getArtifactMap().get("org.netbeans.modules:org-netbeans-insane");
        if (insane == null || Integer.parseInt(insane.getVersion().substring("RELEASE".length())) < 130) {
            return;
        }
        Artifact jth = (Artifact)this.project.getArtifactMap().get("org.jenkins-ci.main:jenkins-test-harness");
        if (jth == null) {
            return;
        }
        Path insaneHook = TestRuntimeMojo.getInsaneHook(this.wrap(jth), this.patchModuleDir.toPath());
        String argLine = String.format("--patch-module='java.base=%s' --add-exports=java.base/org.netbeans.insane.hook=ALL-UNNAMED", insaneHook);
        this.getLog().info((CharSequence)("Setting jenkins.insaneHook to " + argLine));
        this.project.getProperties().setProperty("jenkins.insaneHook", argLine);
    }

    @NonNull
    private static Path getInsaneHook(MavenArtifact artifact, Path patchModuleDir) throws MojoExecutionException {
        Path path;
        File jar = artifact.getFile();
        JarFile jarFile = new JarFile(jar);
        try {
            ZipEntry entry = jarFile.getEntry("netbeans/harness/modules/ext/org-netbeans-insane-hook.jar");
            if (entry == null) {
                throw new MojoExecutionException("Failed to find org-netbeans-insane-hook.jar in " + String.valueOf(jar));
            }
            Files.createDirectories(patchModuleDir, new FileAttribute[0]);
            Path insaneHook = patchModuleDir.resolve("org-netbeans-insane-hook.jar");
            try (InputStream is = jarFile.getInputStream(entry);){
                Files.copy(is, insaneHook, StandardCopyOption.REPLACE_EXISTING);
            }
            path = insaneHook.toAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read org-netbeans-insane-hook.jar from " + String.valueOf(jar), (Exception)e);
            }
        }
        jarFile.close();
        return path;
    }

    private void setJavaAgentProperty() {
        Artifact mockito = (Artifact)this.project.getArtifactMap().get("org.mockito:mockito-core");
        if (mockito == null) {
            return;
        }
        String javaAgent = String.format("-javaagent:'%s'", mockito.getFile());
        this.getLog().info((CharSequence)("Setting jenkins.javaAgent to " + javaAgent));
        this.project.getProperties().setProperty("jenkins.javaAgent", javaAgent);
    }
}

