/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import hudson.util.VersionNumber;
import io.jenkins.lib.versionnumber.JavaSpecificationVersion;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.eclipse.aether.RepositorySystem;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

public abstract class AbstractJenkinsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter
    protected String jenkinsCoreId;
    @Parameter
    private String jenkinsCoreVersionOverride;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected MavenProjectHelper projectHelper;

    protected String findJenkinsVersion() throws MojoExecutionException {
        for (Dependency a : this.project.getDependencies()) {
            boolean match;
            if (this.jenkinsCoreId != null) {
                match = (a.getGroupId() + ":" + a.getArtifactId()).equals(this.jenkinsCoreId);
            } else {
                boolean bl = match = !(!a.getGroupId().equals("org.jenkins-ci.main") && !a.getGroupId().equals("org.jvnet.hudson.main") || !a.getArtifactId().equals("jenkins-core") && !a.getArtifactId().equals("hudson-core"));
            }
            if (!match) continue;
            if (this.jenkinsCoreVersionOverride != null && !this.jenkinsCoreVersionOverride.trim().isEmpty()) {
                VersionNumber v2;
                VersionNumber v1 = new VersionNumber(a.getVersion());
                if (v1.compareTo(v2 = new VersionNumber(this.jenkinsCoreVersionOverride)) == -1) {
                    return this.jenkinsCoreVersionOverride;
                }
                this.getLog().warn((CharSequence)("Ignoring 'jenkinsCoreVersionOverride' of " + this.jenkinsCoreVersionOverride + " as the autodetected version, " + a.getVersion() + ", is newer. Please remove the redundant version override."));
            }
            return a.getVersion();
        }
        if (this.jenkinsCoreVersionOverride != null && !this.jenkinsCoreVersionOverride.trim().isEmpty()) {
            return this.jenkinsCoreVersionOverride;
        }
        throw new MojoExecutionException("Failed to determine Jenkins version this plugin depends on.");
    }

    /*
     * Exception decompiling
     */
    protected JavaSpecificationVersion getMinimumJavaVersion() throws MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Artifact resolveJenkinsCore() throws MojoExecutionException {
        String artifactId;
        String groupId;
        if (this.jenkinsCoreId != null) {
            String[] parts = this.jenkinsCoreId.split(":");
            groupId = parts[0];
            artifactId = parts[1];
        } else {
            groupId = "org.jenkins-ci.main";
            artifactId = "jenkins-core";
        }
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, this.findJenkinsVersion(), null, "jar");
        return MavenArtifact.resolveArtifact(artifact, this.project, this.session, this.repositorySystem);
    }

    protected MavenArtifact wrap(Artifact a) {
        return new MavenArtifact(a, this.repositorySystem, this.artifactFactory, this.projectBuilder, this.session, this.project);
    }
}

