/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import javax.lang.model.SourceVersion;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

@Mojo(name="insert-test", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class TestInsertionMojo
extends AbstractJenkinsMojo {
    @Parameter(property="maven-hpi-plugin.disabledTestInjection", defaultValue="false")
    private boolean disabledTestInjection;
    @Parameter(property="maven-hpi-plugin.injectedTestPackage", defaultValue="${project.groupId}.${project.artifactId}")
    private String injectedTestPackage;
    @Parameter(property="maven-hpi-plugin.injectedTestName", defaultValue="InjectedTest")
    private String injectedTestName;
    @Parameter(property="jelly.requirePI", defaultValue="true")
    private boolean requirePI;
    @Parameter(defaultValue="org.jenkins-ci.main:jenkins-test-harness")
    protected String jenkinsTestHarnessId;

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        block15: {
            if (this.disabledTestInjection) {
                this.getLog().info((CharSequence)"Skipping auto-test generation");
                return;
            }
            if (!this.project.getPackaging().equals("hpi")) {
                Artifact jenkinsTestHarness = null;
                if (this.jenkinsTestHarnessId != null) {
                    for (Artifact b : this.project.getTestArtifacts()) {
                        if (!this.jenkinsTestHarnessId.equals(b.getGroupId() + ":" + b.getArtifactId())) continue;
                        jenkinsTestHarness = b;
                        break;
                    }
                }
                if (jenkinsTestHarness != null) {
                    try {
                        ArtifactVersion version = jenkinsTestHarness.getSelectedVersion();
                        if (version == null || version.compareTo((Object)new DefaultArtifactVersion("2.14")) < 0) {
                            this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging> and the " + this.jenkinsTestHarnessId + ", " + String.valueOf(version) + ", is less than 2.14"));
                            return;
                        }
                        break block15;
                    }
                    catch (OverConstrainedVersionException e) {
                        throw new MojoFailureException("Build should be failed before we get here if there is an over-constrained version", (Throwable)e);
                    }
                }
                this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging> and we could not determine the version of " + this.jenkinsTestHarnessId + " used by this project"));
                return;
            }
        }
        File f = new File(this.project.getBasedir(), "target/generated-test-sources/injected");
        try {
            Files.createDirectories(f.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create injected test directory", (Exception)e);
        }
        String packageName = TestInsertionMojo.legalizePackageName(this.injectedTestPackage);
        File javaFile = new File(f, packageName.replace(".", File.separator) + File.separator + this.injectedTestName + ".java");
        File parentFile = javaFile.getParentFile();
        if (!parentFile.mkdirs()) {
            this.getLog().debug((CharSequence)(String.valueOf(parentFile) + " already existed."));
        }
        try {
            String content = "package %s;\n\nimport org.junit.platform.suite.api.ConfigurationParameter;\nimport org.junit.platform.suite.api.SelectPackages;\nimport org.junit.platform.suite.api.Suite;\n\n/**\n * Entry point for auto-generated tests (generated by maven-hpi-plugin).\n * You can disable the code generation by configuring maven-hpi-plugin to &lt;disabledTestInjection&gt;true&lt;/disabledTestInjection&gt;.\n */\n@Suite\n@ConfigurationParameter(key = \"InjectedTest.basedir\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.groupId\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.artifactId\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.version\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.packaging\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.outputDirectory\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.testOutputDirectory\", value = \"%s\")\n@ConfigurationParameter(key = \"InjectedTest.requirePI\", value = \"%s\")\n@SelectPackages(\"org.jvnet.hudson.test.injected\")\nclass %s {\n\n}\n".formatted(packageName, TestInsertionMojo.escape(this.project.getBasedir().getAbsolutePath()), this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getPackaging(), TestInsertionMojo.escape(this.project.getBuild().getOutputDirectory()), TestInsertionMojo.escape(this.project.getBuild().getTestOutputDirectory()), String.valueOf(this.requirePI), this.injectedTestName);
            Files.writeString(javaFile.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create injected tests", (Exception)e);
        }
        this.project.addTestCompileSourceRoot(f.getAbsolutePath());
        try {
            Files.setLastModifiedTime(javaFile.toPath(), FileTime.fromMillis(0L));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to clear last modified time on " + String.valueOf(javaFile)), (Throwable)e);
        }
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\");
    }

    static String legalizePackageName(@NonNull String input) throws MojoFailureException {
        Object result = input.replace('-', '_');
        if (!((String)result).isEmpty() && Character.isDigit(((String)result).charAt(0))) {
            result = "_" + (String)result;
        }
        if (!SourceVersion.isName((CharSequence)result)) {
            throw new MojoFailureException("Could not convert " + input + " to a legal java package name. Please override \"injectedTestPackage\" with a valid java package name.");
        }
        return result;
    }
}

