/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import jenkins.YesNoMaybe;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.util.Utils;

public abstract class AbstractHpiMojo
extends AbstractJenkinsMojo {
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${project.build.directory}")
    protected String outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project.name}")
    protected String pluginName;
    @Parameter(defaultValue="${plugin.version.description}")
    protected String pluginVersionDescription;
    @Parameter
    protected String snapshotPluginVersionOverride;
    @Parameter(defaultValue="true")
    protected boolean failOnVersionOverrideToDifferentRelease = true;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    private File webappDirectory;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    protected File warSourceDirectory;
    @Parameter
    private Resource[] webResources;
    @Parameter(defaultValue="${project.build.filters}")
    private List<String> filters;
    @Parameter(defaultValue="${maven.war.containerConfigXML}")
    private File containerConfigXML;
    @Parameter(defaultValue="${project.build.directory}/war/work")
    private File workDirectory;
    @Component
    protected ArchiverManager archiverManager;
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    @Parameter(alias="includes", defaultValue="**")
    private String warSourceIncludes;
    @Parameter(alias="excludes")
    private String warSourceExcludes;
    @Parameter(defaultValue="**")
    private String dependentWarIncludes;
    @Parameter
    private String dependentWarExcludes;
    @Parameter
    protected String maskClasses;
    @Parameter
    protected boolean pluginFirstClassLoader = false;
    @Parameter(defaultValue="${hpi.strictBundledArtifacts}")
    private boolean strictBundledArtifacts;
    @Parameter(defaultValue="${hpi.bundledArtifacts}")
    private List<String> bundledArtifacts;
    ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter("runtime");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public File getContainerConfigXML() {
        return this.containerConfigXML;
    }

    public void setContainerConfigXML(File containerConfigXML) {
        this.containerConfigXML = containerConfigXML;
    }

    protected String[] getExcludes() {
        ArrayList<Object> excludeList = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(List.of(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
            excludeList.add("**/META-INF/" + this.containerConfigXML.getName());
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)Objects.toString(this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependentWarExcludes) ? StringUtils.split((String)this.dependentWarExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)Objects.toString(this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webappDirectory, File jarFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding webapp...");
        try {
            Files.createDirectories(webappDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(webappDirectory) + "'", (Exception)e);
        }
        File webinfDir = new File(webappDirectory, WEB_INF);
        try {
            Files.createDirectories(webinfDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(webinfDir) + "'", (Exception)e);
        }
        File metainfDir = new File(webappDirectory, META_INF);
        try {
            Files.createDirectories(metainfDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(metainfDir) + "'", (Exception)e);
        }
        try {
            List<Resource> webResources;
            List<Resource> list = webResources = this.webResources != null ? List.of(this.webResources) : null;
            if (webResources != null && webResources.size() > 0) {
                this.copyResourcesWithFiltering(webResources, webappDirectory);
            }
            this.copyResources(this.warSourceDirectory, webappDirectory);
            if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
                metainfDir = new File(webappDirectory, META_INF);
                String xmlFileName = this.containerConfigXML.getName();
                FileUtils.copyFileIfModified((File)this.containerConfigXML, (File)new File(metainfDir, xmlFileName));
            }
            this.buildWebapp(this.project, webappDirectory);
            FileUtils.copyFileIfModified((File)jarFile, (File)new File(this.getWebappDirectory(), "WEB-INF/lib/" + jarFile.getName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode webapp...", (Exception)e);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Could not copy webResources...", (Exception)((Object)e));
        }
    }

    public void copyResourcesWithFiltering(List<Resource> resources, File webappDirectory) throws MavenFilteringException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, webappDirectory, this.project, StandardCharsets.UTF_8.name(), this.filters, Collections.emptyList(), this.session);
        mavenResourcesExecution.setEscapeString("\\");
        this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
    }

    public void copyResources(File sourceDirectory, File webappDirectory) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (this.warSourceDirectory.exists()) {
                String[] fileNames;
                for (String fileName : fileNames = this.getWarFiles(sourceDirectory)) {
                    FileUtils.copyFileIfModified((File)new File(sourceDirectory, fileName), (File)new File(webappDirectory, fileName));
                }
            }
        }
    }

    public Set<MavenArtifact> getProjectArtfacts() {
        return this.wrap(Artifacts.of(this.project));
    }

    public Set<MavenArtifact> getDirectDependencyArtfacts() {
        return this.wrap(Artifacts.ofDirectDependencies(this.project));
    }

    protected Set<MavenArtifact> wrap(Iterable<Artifact> artifacts) {
        TreeSet<MavenArtifact> r = new TreeSet<MavenArtifact>();
        for (Artifact a : artifacts) {
            r.add(this.wrap(a));
        }
        return r;
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)("Assembling webapp " + project.getArtifactId() + " in " + String.valueOf(webappDirectory)));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        File tldDirectory = new File(webappDirectory, "WEB-INF/tld");
        Set<MavenArtifact> artifacts = this.getProjectArtfacts();
        Set<MavenArtifact> dependencyArtifacts = this.getDirectDependencyArtfacts();
        List<String> duplicates = this.findDuplicates(artifacts);
        ArrayList<File> dependentWarDirectories = new ArrayList<File>();
        HashSet<String> jenkinsPlugins = new HashSet<String>();
        HashSet<String> excludedArtifacts = new HashSet<String>();
        for (Object artifact : Utils.unionOf(artifacts, dependencyArtifacts)) {
            if (((MavenArtifact)artifact).isPlugin(this.getLog())) {
                jenkinsPlugins.add(((MavenArtifact)artifact).getId());
            }
            if (!((MavenArtifact)artifact).hasScope("test", "provided")) continue;
            excludedArtifacts.add(((MavenArtifact)artifact).getId());
        }
        ArrayList<String> actualBundledArtifacts = new ArrayList<String>();
        block1: for (MavenArtifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("Considering artifact trail " + String.valueOf(artifact.getDependencyTrail())));
            if (jenkinsPlugins.contains(artifact.getId()) || artifact.getDependencyTrail().size() >= 1 && (jenkinsPlugins.contains(artifact.getDependencyTrail().get(1)) || excludedArtifacts.contains(artifact.getDependencyTrail().get(1)))) continue;
            for (String trail : artifact.getDependencyTrail()) {
                if (!trail.contains(":hudson-core:") && !trail.contains(":jenkins-core:")) continue;
                continue block1;
            }
            Object targetFileName = artifact.getDefaultFinalName();
            this.getLog().debug((CharSequence)("Processing: " + (String)targetFileName));
            if (duplicates.contains(targetFileName)) {
                this.getLog().debug((CharSequence)("Duplicate found: " + (String)targetFileName));
                targetFileName = artifact.getGroupId() + "-" + (String)targetFileName;
                this.getLog().debug((CharSequence)("Renamed to: " + (String)targetFileName));
            }
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact.artifact)) continue;
            if (artifact.getDependencyTrail().size() > 2) {
                this.getLog().info((CharSequence)("Bundling transitive dependency " + (String)targetFileName + " (via " + artifact.getDependencyTrail().get(1).replaceAll("[^:]+:([^:]+):.+", "$1") + ")"));
            } else {
                this.getLog().info((CharSequence)("Bundling direct dependency " + (String)targetFileName));
            }
            actualBundledArtifacts.add(artifact.getArtifactId());
            String type = artifact.getType();
            if ("tld".equals(type)) {
                FileUtils.copyFileIfModified((File)artifact.getFile(), (File)new File(tldDirectory, (String)targetFileName));
                continue;
            }
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                FileUtils.copyFileIfModified((File)artifact.getFile(), (File)new File(libDirectory, (String)targetFileName));
                continue;
            }
            if ("par".equals(type)) {
                targetFileName = ((String)targetFileName).substring(0, ((String)targetFileName).lastIndexOf(46)) + ".jar";
                this.getLog().debug((CharSequence)("Copying " + String.valueOf(artifact.getFile()) + " to " + String.valueOf(new File(libDirectory, (String)targetFileName))));
                FileUtils.copyFileIfModified((File)artifact.getFile(), (File)new File(libDirectory, (String)targetFileName));
                continue;
            }
            if ("war".equals(type)) {
                dependentWarDirectories.add(this.unpackWarToTempDirectory(artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for WEB-INF/lib"));
        }
        Collections.sort(actualBundledArtifacts);
        if (!actualBundledArtifacts.equals(this.bundledArtifacts)) {
            String message = "Expected list of bundled artifacts %s did not match actual list of bundled artifacts %s. Review the bundled artifacts and add `<hpi.bundledArtifacts>%s</hpi.bundledArtifacts>` to `<properties>` in pom.xml if the actual list is correct. If the actual list is not correct, add `<exclusion>`s or modify dependencies as needed to prevent the artifacts from being bundled. Review https://www.jenkins.io/doc/developer/plugin-development/dependencies-and-class-loading/#bundling-third-party-libraries for more details.".formatted(this.bundledArtifacts, actualBundledArtifacts, String.join((CharSequence)",", actualBundledArtifacts));
            if (this.strictBundledArtifacts) {
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)(message + " Enable strict checks by adding `<hpi.strictBundledArtifacts>true</hpi.strictBundledArtifacts>` to pom.xml"));
        }
        if (dependentWarDirectories.size() > 0) {
            this.getLog().info((CharSequence)("Overlaying " + dependentWarDirectories.size() + " war(s)."));
            for (File dependentWarDirectory : dependentWarDirectories) {
                this.copyDependentWarContents(dependentWarDirectory, webappDirectory);
            }
        }
    }

    private List<String> findDuplicates(Set<MavenArtifact> artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (MavenArtifact artifact : artifacts) {
            String candidate = artifact.getDefaultFinalName();
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private File unpackWarToTempDirectory(MavenArtifact artifact) throws MojoExecutionException {
        String name = artifact.getFile().getName();
        File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
        boolean process = false;
        if (!Files.isDirectory(tempLocation.toPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(tempLocation.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(tempLocation) + "'", (Exception)e);
            }
            process = true;
        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
            process = true;
        }
        if (process) {
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
        return tempLocation;
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + String.valueOf(file) + "to: " + String.valueOf(location), (Exception)((Object)e));
        }
    }

    private void copyDependentWarContents(File srcDir, File targetDir) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.setExcludes(this.getDependentWarExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getDependentWarIncludes());
        scanner.scan();
        for (String dir : scanner.getIncludedDirectories()) {
            File includeDir = new File(targetDir, dir);
            try {
                Files.createDirectories(includeDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(includeDir) + "'", (Exception)e);
            }
        }
        for (String file : scanner.getIncludedFiles()) {
            File targetFile = new File(targetDir, file);
            if (Files.exists(targetFile.toPath(), new LinkOption[0])) continue;
            try {
                Files.createDirectories(targetFile.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create parent directories for '" + String.valueOf(targetFile) + "'", (Exception)e);
            }
            try {
                FileUtils.copyFileIfModified((File)new File(srcDir, file), (File)targetFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + file + "' to '" + String.valueOf(targetFile) + "'", (Exception)e);
            }
        }
    }

    private String[] getWarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public String getGitHeadSha1() {
        if (!this.project.getScm().getConnection().startsWith("scm:git")) {
            return null;
        }
        try {
            String v;
            Process p = new ProcessBuilder("git", "rev-parse", "HEAD").directory(this.project.getBasedir()).redirectErrorStream(true).start();
            p.getOutputStream().close();
            try (InputStream is = p.getInputStream();){
                v = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset()).trim();
            }
            if (p.waitFor() != 0) {
                return null;
            }
            if (v.length() < 8) {
                return null;
            }
            return v;
        }
        catch (IOException | InterruptedException e) {
            this.getLog().debug((CharSequence)"Failed to run git rev-parse HEAD", (Throwable)e);
            return null;
        }
    }

    @CheckForNull
    protected Boolean isSupportDynamicLoading() throws IOException {
        try (URLClassLoader cl = new URLClassLoader(new URL[]{new File(this.project.getBuild().getOutputDirectory()).toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());){
            Object object;
            EnumSet<YesNoMaybe> e = EnumSet.noneOf(YesNoMaybe.class);
            for (IndexItem i : Index.load(Extension.class, Object.class, (ClassLoader)cl)) {
                e.add(((Extension)i.annotation()).dynamicLoadable());
            }
            if (e.contains((Object)YesNoMaybe.NO)) {
                object = Boolean.FALSE;
                return object;
            }
            if (e.contains((Object)YesNoMaybe.MAYBE)) {
                object = null;
                return object;
            }
            object = Boolean.TRUE;
            return object;
        }
    }
}

