/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.yamlaxis.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class MatrixUtils {
    private MatrixUtils() {
    }

    public static <T extends Map<?, ?>> boolean contains(T parent, T child) {
        return child.entrySet().stream().allMatch(entry -> parent.containsKey(entry.getKey()) && parent.get(entry.getKey()).equals(entry.getValue()));
    }

    public static <T extends Map<?, ?>> List<T> reject(List<T> variables, List<T> excludes) {
        if (excludes.isEmpty()) {
            return variables;
        }
        return variables.stream().filter(variable -> excludes.stream().noneMatch(exclude -> MatrixUtils.contains(variable, exclude))).collect(Collectors.toList());
    }
}

