/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.yamlaxis;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixExecutionStrategyDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.yamlaxis.BaseMES;
import org.jenkinsci.plugins.yamlaxis.YamlFileLoader;
import org.jenkinsci.plugins.yamlaxis.YamlLoader;
import org.jenkinsci.plugins.yamlaxis.YamlTextLoader;
import org.jenkinsci.plugins.yamlaxis.util.BuildUtils;
import org.jenkinsci.plugins.yamlaxis.util.DescriptorUtils;
import org.jenkinsci.plugins.yamlaxis.util.MatrixUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class YamlMatrixExecutionStrategy
extends BaseMES {
    private String yamlType = "file";
    private String yamlFile;
    private String yamlText;
    private String excludeKey;
    private volatile List<Combination> excludes = null;

    @DataBoundConstructor
    public YamlMatrixExecutionStrategy(String yamlType, String yamlText, String yamlFile, String excludeKey) {
        this.yamlType = yamlType;
        this.yamlText = yamlText;
        this.yamlFile = yamlFile;
        this.excludeKey = excludeKey;
    }

    public YamlMatrixExecutionStrategy(List<Combination> excludes) {
        this.excludes = excludes;
    }

    @Override
    public Map<String, List<Combination>> decideOrder(MatrixBuild.MatrixBuildExecution execution, List<Combination> comb) {
        List<Combination> excludeCombinations = this.loadExcludes(execution);
        final List<Combination> combinations = MatrixUtils.reject(comb, excludeCombinations);
        BuildUtils.log(execution, "excludes=" + String.valueOf(excludeCombinations));
        return new HashMap<String, List<Combination>>(){
            {
                this.put("YamlMatrixExecutionStrategy", combinations);
            }
        };
    }

    public boolean isYamlTypeFile() {
        return this.yamlType.equals("file");
    }

    public boolean isYamlTypeText() {
        return this.yamlType.equals("text");
    }

    private List<Combination> loadExcludes(MatrixBuild.MatrixBuildExecution execution) {
        if (this.excludes != null) {
            return this.excludes;
        }
        try {
            List<Map<String, ?>> values = this.getYamlLoader(execution).loadMaps(this.excludeKey);
            if (values == null) {
                BuildUtils.log(execution, "[WARN] NotFound excludeKey " + this.excludeKey);
                return new ArrayList<Combination>();
            }
            return YamlMatrixExecutionStrategy.collectExcludeCombinations(values);
        }
        catch (Exception e) {
            BuildUtils.log(execution, "[WARN] Can not read yamlFile: " + this.yamlFile, e);
            return new ArrayList<Combination>();
        }
    }

    public static List<Combination> collectExcludeCombinations(List<Map<String, ?>> excludes) {
        ArrayList result = new ArrayList();
        for (Map<String, ?> value : excludes) {
            ArrayList combos = new ArrayList();
            boolean isList = false;
            for (final Map.Entry<String, ?> entry : value.entrySet()) {
                if (!(entry.getValue() instanceof List)) continue;
                isList = true;
                ArrayList newCombos = new ArrayList();
                for (final Object v2 : (List)entry.getValue()) {
                    if (!combos.isEmpty()) {
                        for (Map map : combos) {
                            HashMap<String, String> clone = new HashMap<String, String>(map);
                            clone.put(entry.getKey(), (String)v2);
                            newCombos.add(clone);
                        }
                        continue;
                    }
                    newCombos.add(new HashMap<String, String>(){
                        {
                            this.put((String)entry.getKey(), (String)v2);
                        }
                    });
                }
                combos = newCombos;
            }
            if (isList) {
                for (final Map.Entry<String, ?> entry : value.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    for (Map map : combos) {
                        map.put(entry.getKey(), (String)entry.getValue());
                    }
                }
            } else if (value.values().stream().allMatch(v -> v instanceof String)) {
                combos.add(value);
            }
            result.addAll(combos);
        }
        ArrayList<Combination> combinations = new ArrayList<Combination>();
        for (Map map : result) {
            combinations.add(new Combination(map));
        }
        return combinations;
    }

    private YamlLoader getYamlLoader(MatrixBuild.MatrixBuildExecution execution) {
        return switch (this.yamlType) {
            case "file" -> {
                FilePath workspace = ((MatrixBuild)execution.getBuild()).getModuleRoot();
                yield new YamlFileLoader(this.yamlFile, workspace);
            }
            case "text" -> new YamlTextLoader(this.yamlText);
            default -> throw new IllegalArgumentException(this.yamlType + " is unknown");
        };
    }

    @Extension
    public static class DescriptorImpl
    extends MatrixExecutionStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Yaml matrix execution strategy";
        }

        public YamlMatrixExecutionStrategy newInstance(StaplerRequest2 req, @NonNull JSONObject formData) {
            String yamlType = formData.getString("yamlType");
            String yamlFile = formData.getString("yamlFile");
            String yamlText = formData.getString("yamlText");
            String excludeKey = formData.getString("excludeKey");
            return new YamlMatrixExecutionStrategy(yamlType, yamlText, yamlFile, excludeKey);
        }

        public FormValidation doCheckYamlFile(@QueryParameter String value) {
            return DescriptorUtils.checkFieldNotEmpty(value, "yamlFile");
        }

        public FormValidation doCheckYamlText(@QueryParameter String value) {
            return DescriptorUtils.checkFieldNotEmpty(value, "yamlText");
        }
    }
}

