/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.yamlaxis;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.console.ModelHyperlinkNote;
import hudson.matrix.Combination;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixChildAction;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixExecutionStrategy;
import hudson.matrix.MatrixRun;
import hudson.matrix.listeners.MatrixBuildListener;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class BaseMES
extends MatrixExecutionStrategy {
    BaseMES() {
    }

    public Result run(MatrixBuild.MatrixBuildExecution execution) throws InterruptedException, IOException {
        ArrayList<Combination> combs = new ArrayList<Combination>();
        HashMap<Combination, MatrixConfiguration> mc = new HashMap<Combination, MatrixConfiguration>();
        for (MatrixConfiguration it : execution.getActiveConfigurations()) {
            Combination c = it.getCombination();
            if (!MatrixBuildListener.buildConfiguration((MatrixBuild)((MatrixBuild)execution.getBuild()), (MatrixConfiguration)it)) continue;
            combs.add(c);
            mc.put(c, it);
        }
        Result r = Result.SUCCESS;
        Map<String, List<Combination>> multiCombs = this.decideOrder(execution, combs);
        if (this.notifyStartBuild(execution.getAggregators())) {
            return Result.FAILURE;
        }
        for (Map.Entry<String, List<Combination>> pair : multiCombs.entrySet()) {
            MatrixConfiguration mc2;
            String k = pair.getKey();
            List<Combination> v = pair.getValue();
            execution.getListener().getLogger().println("Running " + k);
            for (Combination inner : v) {
                mc2 = (MatrixConfiguration)mc.get(inner);
                this.scheduleConfigurationBuild(execution, mc2);
            }
            for (Combination inner : v) {
                mc2 = (MatrixConfiguration)mc.get(inner);
                MatrixRun run = this.waitForCompletion(execution, mc2);
                this.notifyEndBuild(run, execution.getAggregators());
                execution.getListener().getLogger().println("Completed " + ModelHyperlinkNote.encodeTo((Item)mc2) + " " + String.valueOf(this.getResult(run)));
                r = r.combine(this.getResult(run));
            }
            if (r != Result.FAILURE) continue;
            return r;
        }
        return r;
    }

    abstract Map<String, List<Combination>> decideOrder(MatrixBuild.MatrixBuildExecution var1, List<Combination> var2);

    void scheduleConfigurationBuild(MatrixBuild.MatrixBuildExecution exec, MatrixConfiguration c) {
        MatrixBuild build = (MatrixBuild)exec.getBuild();
        exec.getListener().getLogger().println("Triggering " + ModelHyperlinkNote.encodeTo((Item)c));
        ArrayList childActions = new ArrayList(build.getActions(MatrixChildAction.class));
        childActions.addAll(build.getActions(ParametersAction.class));
        c.scheduleBuild(childActions, (Cause)new Cause.UpstreamCause((Run)build));
    }

    MatrixRun waitForCompletion(MatrixBuild.MatrixBuildExecution exec, MatrixConfiguration c) throws InterruptedException {
        BuildListener listener = exec.getListener();
        String whyInQueue = "";
        long startTime = System.currentTimeMillis();
        int appearsCancelledCount = 0;
        Result buildResult;
        MatrixRun b;
        while ((b = (MatrixRun)c.getBuildByNumber(((MatrixBuild)exec.getBuild()).number)) == null || b.isBuilding() || (buildResult = b.getResult()) == null) {
            String why;
            Queue.Item qi = c.getQueueItem();
            appearsCancelledCount = b == null && qi == null ? ++appearsCancelledCount : 0;
            if (appearsCancelledCount >= 5) {
                listener.getLogger().println(ModelHyperlinkNote.encodeTo((Item)c) + " appears to be cancelled");
                return null;
            }
            if (qi != null && (why = qi.getWhy()) != null && !why.equals(whyInQueue) && System.currentTimeMillis() - startTime > 5000L) {
                listener.getLogger().print("Configuration " + ModelHyperlinkNote.encodeTo((Item)c) + " is still in the queue: ");
                qi.getCauseOfBlockage().print((TaskListener)listener);
                whyInQueue = why;
            }
            Thread.sleep(1000L);
        }
        return b;
    }

    Result getResult(@Nullable MatrixRun run) {
        return run != null ? run.getResult() : Result.ABORTED;
    }

    boolean notifyStartBuild(List<MatrixAggregator> aggregators) throws InterruptedException, IOException {
        for (MatrixAggregator a : aggregators) {
            if (a.startBuild()) continue;
            return true;
        }
        return false;
    }

    void notifyEndBuild(MatrixRun b, List<MatrixAggregator> aggregators) throws InterruptedException, IOException {
        if (b == null) {
            return;
        }
        for (MatrixAggregator a : aggregators) {
            if (a.endRun(b)) continue;
            throw new AbortException();
        }
    }
}

