/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.yamlaxis;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.MatrixBuild;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.yamlaxis.YamlFileLoader;
import org.jenkinsci.plugins.yamlaxis.util.BuildUtils;
import org.jenkinsci.plugins.yamlaxis.util.DescriptorUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class YamlAxis
extends Axis {
    private List<String> computedValues;

    @DataBoundConstructor
    public YamlAxis(String name, String valueString, List<String> computedValues) {
        super(name, valueString);
        this.computedValues = computedValues;
    }

    public List<String> getValues() {
        if (this.computedValues != null) {
            return this.computedValues;
        }
        YamlFileLoader loader = new YamlFileLoader(this.getYamlFile(), null);
        try {
            this.computedValues = loader.loadStrings(this.getName());
            return this.computedValues;
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public List<String> rebuild(MatrixBuild.MatrixBuildExecution context) {
        FilePath workspace = ((MatrixBuild)context.getBuild()).getModuleRoot();
        YamlFileLoader loader = new YamlFileLoader(this.getYamlFile(), workspace);
        try {
            this.computedValues = loader.loadStrings(this.getName());
            return this.computedValues;
        }
        catch (Exception e) {
            BuildUtils.log(context, "[WARN] Cannot read yamlFile: " + this.getYamlFile(), e);
            return List.of();
        }
    }

    public String getYamlFile() {
        return this.getValueString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YamlAxis)) {
            return false;
        }
        YamlAxis yamlAxis = (YamlAxis)((Object)o);
        return Objects.equals(this.computedValues, yamlAxis.computedValues);
    }

    public int hashCode() {
        return this.computedValues != null ? this.computedValues.hashCode() : 0;
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Yaml Axis";
        }

        public Axis newInstance(StaplerRequest2 req, @NonNull JSONObject formData) {
            String name = formData.getString("name");
            String yamlFile = formData.getString("valueString");
            return new YamlAxis(name, yamlFile, null);
        }

        public FormValidation doCheckValueString(@QueryParameter String value) {
            return DescriptorUtils.checkFieldNotEmpty(value, "valueString");
        }
    }
}

