// CHECKSTYLE:OFF

package org.jenkinsci.plugins.xunit.pipeline;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code XUnitResultsStepExecution.noTool}: {@code At least one tool

     * must be specified for the xunit step.}.
     * 
     * @return
     *     {@code At least one tool must be specified for the xunit step.}
     */
    public static String XUnitResultsStepExecution_noTool() {
        return holder.format("XUnitResultsStepExecution.noTool");
    }

    /**
     * Key {@code XUnitResultsStepExecution.noTool}: {@code At least one tool

     * must be specified for the xunit step.}.
     * 
     * @return
     *     {@code At least one tool must be specified for the xunit step.}
     */
    public static Localizable _XUnitResultsStepExecution_noTool() {
        return new Localizable(holder, "XUnitResultsStepExecution.noTool");
    }

}
