// CHECKSTYLE:OFF

package org.jenkinsci.plugins.xunit;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code xUnitProcessor.xslFileNotFound}: {@code The XSL file

     * ''{0}'' doesn't exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The XSL file ''{0}'' doesn't exist.}
     */
    public static String xUnitProcessor_xslFileNotFound(Object arg0) {
        return holder.format("xUnitProcessor.xslFileNotFound", arg0);
    }

    /**
     * Key {@code xUnitProcessor.xslFileNotFound}: {@code The XSL file

     * ''{0}'' doesn't exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The XSL file ''{0}'' doesn't exist.}
     */
    public static Localizable _xUnitProcessor_xslFileNotFound(Object arg0) {
        return new Localizable(holder, "xUnitProcessor.xslFileNotFound", arg0);
    }

    /**
     * Key {@code xUnit.PublisherName}: {@code Publish xUnit test result

     * report}.
     * 
     * @return
     *     {@code Publish xUnit test result report}
     */
    public static String xUnit_PublisherName() {
        return holder.format("xUnit.PublisherName");
    }

    /**
     * Key {@code xUnit.PublisherName}: {@code Publish xUnit test result

     * report}.
     * 
     * @return
     *     {@code Publish xUnit test result report}
     */
    public static Localizable _xUnit_PublisherName() {
        return new Localizable(holder, "xUnit.PublisherName");
    }

    /**
     * Key {@code xUnitProcessor.checkThreshold}: {@code Check ''{0}''

     * threshold.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Check ''{0}'' threshold.}
     */
    public static String xUnitProcessor_checkThreshold(Object arg0) {
        return holder.format("xUnitProcessor.checkThreshold", arg0);
    }

    /**
     * Key {@code xUnitProcessor.checkThreshold}: {@code Check ''{0}''

     * threshold.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Check ''{0}'' threshold.}
     */
    public static Localizable _xUnitProcessor_checkThreshold(Object arg0) {
        return new Localizable(holder, "xUnitProcessor.checkThreshold", arg0);
    }

    /**
     * Key {@code xUnitProcessor.emptyReport}: {@code All test reports are

     * empty.}.
     * 
     * @return
     *     {@code All test reports are empty.}
     */
    public static String xUnitProcessor_emptyReport() {
        return holder.format("xUnitProcessor.emptyReport");
    }

    /**
     * Key {@code xUnitProcessor.emptyReport}: {@code All test reports are

     * empty.}.
     * 
     * @return
     *     {@code All test reports are empty.}
     */
    public static Localizable _xUnitProcessor_emptyReport() {
        return new Localizable(holder, "xUnitProcessor.emptyReport");
    }

    /**
     * Key {@code xUnitProcessor.checkSleepTime}: {@code Time must be a

     * positive or zero number}.
     * 
     * @return
     *     {@code Time must be a positive or zero number}
     */
    public static String xUnitProcessor_checkSleepTime() {
        return holder.format("xUnitProcessor.checkSleepTime");
    }

    /**
     * Key {@code xUnitProcessor.checkSleepTime}: {@code Time must be a

     * positive or zero number}.
     * 
     * @return
     *     {@code Time must be a positive or zero number}
     */
    public static Localizable _xUnitProcessor_checkSleepTime() {
        return new Localizable(holder, "xUnitProcessor.checkSleepTime");
    }

}
