/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.Utils;

import com.xpandit.plugins.xrayjenkins.exceptions.XrayJenkinsGenericException;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.plugins.xrayjenkins.model.ServerConfiguration;
import com.xpandit.plugins.xrayjenkins.model.XrayInstance;
import hudson.util.ListBoxModel;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FormUtils {
    public static ListBoxModel getServerInstanceItems() {
        ListBoxModel items = new ListBoxModel();
        List<XrayInstance> serverInstances = ServerConfiguration.get().getServerInstances();
        if (CollectionUtils.isEmpty(serverInstances)) {
            return items;
        }
        for (XrayInstance sc : serverInstances) {
            HostingType instanceHostingType = sc.getHosting();
            if (instanceHostingType == null) {
                throw new XrayJenkinsGenericException("Null hosting type found");
            }
            String alias = sc.getAlias();
            if (StringUtils.isBlank((String)sc.getCredentialId())) {
                alias = "[User Auth required] " + alias;
            }
            items.add(alias, instanceHostingType.toString() + "-" + sc.getConfigID());
        }
        return items;
    }
}

