/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.Utils;

import com.google.common.collect.Iterables;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.plugins.xrayjenkins.model.ServerConfiguration;
import com.xpandit.plugins.xrayjenkins.model.XrayInstance;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);

    @Nullable
    public static XrayInstance getConfiguration(String serverConfigurationId) {
        if (StringUtils.isBlank((CharSequence)serverConfigurationId)) {
            return null;
        }
        if (serverConfigurationId.startsWith(HostingType.CLOUD.toString())) {
            serverConfigurationId = StringUtils.removeStart((String)serverConfigurationId, (String)(HostingType.getCloudHostingName() + "-"));
        } else if (serverConfigurationId.startsWith(HostingType.SERVER.toString())) {
            serverConfigurationId = StringUtils.removeStart((String)serverConfigurationId, (String)(HostingType.getServerHostingName() + "-"));
        }
        XrayInstance config = null;
        List<XrayInstance> serverInstances = ServerConfiguration.get().getServerInstances();
        for (XrayInstance sc : serverInstances) {
            if (!sc.getConfigID().equals(serverConfigurationId)) continue;
            config = sc;
            break;
        }
        if (config == null) {
            LOG.error("No XrayInstance could be found with configuration id '{}'", (Object)serverConfigurationId);
        }
        return config;
    }

    @Nullable
    public static XrayInstance getConfigurationOrFirstAvailable(String serverConfigurationId) {
        return Optional.ofNullable(ConfigurationUtils.getConfiguration(serverConfigurationId)).orElseGet(() -> (XrayInstance)Iterables.getFirst(ServerConfiguration.get().getServerInstances(), null));
    }

    public static boolean anyAvailableConfiguration() {
        ServerConfiguration configuration = ServerConfiguration.get();
        return configuration != null && configuration.getServerInstances() != null && configuration.getServerInstances().size() > 0;
    }
}

