/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.tasks.BuildTrigger;
import hudson.util.FormValidation;
import java.util.Collections;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class BuildTriggerTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private JenkinsRule r;

    BuildTriggerTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void smokes() throws Exception {
        BuildTrigger.DescriptorImpl d = (BuildTrigger.DescriptorImpl)this.r.jenkins.getDescriptorByType(BuildTrigger.DescriptorImpl.class);
        FreeStyleProject us = (FreeStyleProject)this.r.createProject(FreeStyleProject.class, "us");
        WorkflowJob ds = (WorkflowJob)this.r.createProject(WorkflowJob.class, "ds");
        ds.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        Assertions.assertEquals(Collections.singletonList("ds"), (Object)d.doAutoCompleteChildProjects("d", (Item)us, (ItemGroup)this.r.jenkins).getValues());
        FormValidation validation = d.doCheck((AbstractProject)us, "ds");
        Assertions.assertEquals((Object)FormValidation.Kind.OK, (Object)validation.kind, (String)validation.renderHtml());
        us.getPublishersList().add((Object)new BuildTrigger("ds", Result.SUCCESS));
        this.r.jenkins.setQuietPeriod(Integer.valueOf(0));
        FreeStyleBuild us1 = this.r.buildAndAssertSuccess(us);
        this.r.waitUntilNoActivity();
        WorkflowRun ds1 = ds.getLastBuild();
        Assertions.assertNotNull((Object)ds1, (String)"triggered");
        Cause.UpstreamCause cause = (Cause.UpstreamCause)ds1.getCause(Cause.UpstreamCause.class);
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)us1, (Object)cause.getUpstreamRun());
    }
}

