/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.service.model.ServiceData;
import hudson.model.Result;
import java.io.PrintWriter;
import org.apache.commons.lang3.time.DurationFormatUtils;

public abstract class StoragePluginService<T extends ServiceData> {
    protected static final String FP_SEPARATOR = ",";
    private T serviceData;

    protected StoragePluginService(T serviceData) {
        this.serviceData = serviceData;
    }

    public abstract int execute() throws WAStorageException;

    protected void setRunUnstable() {
        ((ServiceData)this.serviceData).getRun().setResult(Result.UNSTABLE);
    }

    protected void println(String message) {
        ((ServiceData)this.serviceData).getTaskListener().getLogger().println(message);
    }

    protected PrintWriter error(String message) {
        return ((ServiceData)this.serviceData).getTaskListener().error(message);
    }

    protected String getTime(long timeInMills) {
        return DurationFormatUtils.formatDuration((long)timeInMills, (String)"HH:mm:ss.S") + " (HH:mm:ss.S)";
    }

    public T getServiceData() {
        return this.serviceData;
    }

    public void setServiceData(T serviceData) {
        this.serviceData = serviceData;
    }
}

