/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service.model;

import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.service.model.ServiceData;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildSelector;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DownloadServiceData
extends ServiceData {
    private String includeFilesPattern;
    private String excludeFilesPattern;
    private String containerName;
    private String fileShare;
    private String downloadDirLoc;
    private boolean flattenDirectories;
    private boolean deleteFromAzureAfterDownload;
    private String downloadType;
    private String projectName;
    private BuildSelector buildSelector;
    private boolean includeArchiveZips;

    public DownloadServiceData(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener taskListener, StorageAccountInfo storageAccountInfo) {
        super(run, workspace, launcher, taskListener, storageAccountInfo);
    }

    public FilePath getDownloadDir() {
        FilePath downloadDir = this.getRemoteWorkspace();
        try {
            if (!StringUtils.isBlank((String)this.downloadDirLoc)) {
                EnvVars envVars = this.getRun().getEnvironment(this.getTaskListener());
                downloadDir = new FilePath(this.getRemoteWorkspace(), Util.replaceMacro((String)this.downloadDirLoc, (Map)envVars));
            }
            if (!downloadDir.exists()) {
                downloadDir.mkdirs();
            }
        }
        catch (IOException | InterruptedException e) {
            this.getRun().setResult(Result.UNSTABLE);
        }
        return downloadDir;
    }

    public String getIncludeFilesPattern() {
        return this.includeFilesPattern;
    }

    public void setIncludeFilesPattern(String includeFilesPattern) {
        this.includeFilesPattern = includeFilesPattern;
    }

    public String getExcludeFilesPattern() {
        return this.excludeFilesPattern;
    }

    public void setExcludeFilesPattern(String excludeFilesPattern) {
        this.excludeFilesPattern = excludeFilesPattern;
    }

    public String getDownloadDirLoc() {
        return this.downloadDirLoc;
    }

    public void setDownloadDirLoc(String downloadDirLoc) {
        this.downloadDirLoc = downloadDirLoc;
    }

    public boolean isFlattenDirectories() {
        return this.flattenDirectories;
    }

    public void setFlattenDirectories(boolean flattenDirectories) {
        this.flattenDirectories = flattenDirectories;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public boolean isDeleteFromAzureAfterDownload() {
        return this.deleteFromAzureAfterDownload;
    }

    public void setDeleteFromAzureAfterDownload(boolean deleteFromAzureAfterDownload) {
        this.deleteFromAzureAfterDownload = deleteFromAzureAfterDownload;
    }

    public String getDownloadType() {
        return this.downloadType;
    }

    public void setDownloadType(String downloadType) {
        this.downloadType = downloadType;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BuildSelector getBuildSelector() {
        return this.buildSelector;
    }

    public void setBuildSelector(BuildSelector buildSelector) {
        this.buildSelector = buildSelector;
    }

    public boolean isIncludeArchiveZips() {
        return this.includeArchiveZips;
    }

    public void setIncludeArchiveZips(boolean includeArchiveZips) {
        this.includeArchiveZips = includeArchiveZips;
    }

    public String getFileShare() {
        return this.fileShare;
    }

    public void setFileShare(String fileShare) {
        this.fileShare = fileShare;
    }
}

