/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.WAStoragePublisher;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.helper.Utils;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadFromBuildService;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadFromContainerService;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadFromFileService;
import com.microsoftopentechnologies.windowsazurestorage.service.StoragePluginService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.DownloadServiceData;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class AzureStorageBuilder
extends Builder
implements SimpleBuildStep {
    public static final String DOWNLOAD_TYPE_CONTAINER = "container";
    public static final String DOWNLOAD_TYPE_PROJECT = "project";
    public static final String DOWNLOAD_TYPE_FILE_SHARE = "share";
    static final String CONTAINER = "container";
    private final String downloadType;
    private boolean deleteFromAzureAfterDownload;
    private final String storageCredentialId;
    private String containerName = "";
    private String fileShare;
    private String includeFilesPattern = "";
    private String excludeFilesPattern = "";
    private String downloadDirLoc = "";
    private boolean flattenDirectories;
    private boolean includeArchiveZips;
    private BuildSelector buildSelector;
    private String projectName = "";
    private boolean verbose;
    private transient AzureStorageAccount.StorageAccountCredential storageCreds;

    @DataBoundConstructor
    public AzureStorageBuilder(String storageCredentialId, String downloadType) {
        this.storageCredentialId = storageCredentialId;
        this.downloadType = downloadType;
    }

    @DataBoundSetter
    public void setIncludeFilesPattern(String includeFilesPattern) {
        this.includeFilesPattern = includeFilesPattern;
    }

    @DataBoundSetter
    public void setExcludeFilesPattern(String excludeFilesPattern) {
        this.excludeFilesPattern = excludeFilesPattern;
    }

    @DataBoundSetter
    public void setDownloadDirLoc(String downloadDirLoc) {
        this.downloadDirLoc = downloadDirLoc;
    }

    @DataBoundSetter
    public void setFlattenDirectories(boolean flattenDirectories) {
        this.flattenDirectories = flattenDirectories;
    }

    @DataBoundSetter
    public void setIncludeArchiveZips(boolean includeArchiveZips) {
        this.includeArchiveZips = includeArchiveZips;
    }

    @DataBoundSetter
    public void setContainerName(String containerName) {
        if (this.getDownloadType().equals("container")) {
            this.containerName = containerName;
        }
    }

    @DataBoundSetter
    public void setFileShare(String fileShare) {
        this.fileShare = Util.fixEmpty((String)fileShare);
    }

    @DataBoundSetter
    public void setBuildSelector(BuildSelector buildSelector) {
        if (this.getDownloadType().equals(DOWNLOAD_TYPE_PROJECT)) {
            this.buildSelector = buildSelector;
        }
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        if (this.getDownloadType().equals(DOWNLOAD_TYPE_PROJECT)) {
            this.projectName = projectName;
        }
    }

    public boolean isDeleteFromAzureAfterDownload() {
        return this.deleteFromAzureAfterDownload;
    }

    @DataBoundSetter
    public void setDeleteFromAzureAfterDownload(boolean deleteFromAzureAfterDownload) {
        this.deleteFromAzureAfterDownload = deleteFromAzureAfterDownload;
    }

    public BuildSelector getBuildSelector() {
        return this.buildSelector;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @DataBoundSetter
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Deprecated
    public String getStorageAccName() {
        return this.getStorageAccName(null);
    }

    public String getStorageAccName(Item owner) {
        AzureStorageAccount.StorageAccountCredential credential = this.getStorageAccountCredential(owner);
        if (credential != null) {
            return credential.getStorageAccountName();
        }
        return null;
    }

    public String getDownloadType() {
        if (DOWNLOAD_TYPE_FILE_SHARE.equals(this.downloadType) || DOWNLOAD_TYPE_PROJECT.equals(this.downloadType)) {
            return this.downloadType;
        }
        return "container";
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getIncludeFilesPattern() {
        return this.includeFilesPattern;
    }

    public String getExcludeFilesPattern() {
        return this.excludeFilesPattern;
    }

    public String getDownloadDirLoc() {
        return this.downloadDirLoc;
    }

    public boolean isIncludeArchiveZips() {
        return this.includeArchiveZips;
    }

    public boolean isFlattenDirectories() {
        return this.flattenDirectories;
    }

    public String getFileShare() {
        return this.fileShare;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getStorageCredentialId() {
        return this.storageCredentialId;
    }

    public AzureStorageAccount.StorageAccountCredential getStorageAccountCredential(Item owner) {
        if (this.storageCreds == null) {
            this.storageCreds = AzureStorageAccount.getStorageAccountCredential(owner, this.getStorageCredentialId());
        }
        return this.storageCreds;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException {
        AzureStorageAccount.StorageAccountCredential credential = this.getStorageAccountCredential((Item)run.getParent());
        if (credential == null) {
            throw new AbortException(String.format("Cannot find storage account credentials with ID: '%s'", this.getStorageCredentialId()));
        }
        StorageAccountInfo storageAccountInfo = AzureStorageAccount.convertToStorageAccountInfo(credential);
        try {
            this.validateData(run, listener, storageAccountInfo);
            EnvVars envVars = run.getEnvironment(listener);
            DownloadServiceData builderServiceData = new DownloadServiceData(run, workspace, launcher, listener, storageAccountInfo);
            String expIncludePattern = Utils.replaceMacro(this.includeFilesPattern, (Map<String, String>)envVars);
            if (StringUtils.isBlank((String)expIncludePattern)) {
                expIncludePattern = "**/*";
            }
            Object expExcludePattern = Utils.replaceMacro(this.excludeFilesPattern, (Map<String, String>)envVars);
            if (!this.includeArchiveZips) {
                expExcludePattern = expExcludePattern != null ? (String)expExcludePattern + ",archive.zip" : "archive.zip";
            }
            String expContainerName = Utils.replaceMacro(Util.fixNull((String)this.containerName), (Map<String, String>)envVars, Locale.ENGLISH);
            String expShareName = Utils.replaceMacro(Util.fixNull((String)this.fileShare), (Map<String, String>)envVars, Locale.ENGLISH);
            builderServiceData.setIncludeFilesPattern(expIncludePattern);
            builderServiceData.setExcludeFilesPattern((String)expExcludePattern);
            builderServiceData.setDownloadDirLoc(Util.replaceMacro((String)this.downloadDirLoc, (Map)envVars));
            builderServiceData.setContainerName(expContainerName);
            builderServiceData.setFileShare(expShareName);
            builderServiceData.setFlattenDirectories(this.flattenDirectories);
            builderServiceData.setDeleteFromAzureAfterDownload(this.deleteFromAzureAfterDownload);
            builderServiceData.setDownloadType(this.getDownloadType());
            builderServiceData.setProjectName(Util.replaceMacro((String)this.projectName, (Map)envVars));
            builderServiceData.setBuildSelector(this.buildSelector);
            builderServiceData.setVerbose(this.isVerbose());
            StoragePluginService<DownloadServiceData> downloadService = this.getDownloadService(builderServiceData);
            int filesDownloaded = downloadService.execute();
            if (filesDownloaded == 0) {
                listener.getLogger().println(Messages.AzureStorageBuilder_nofiles_downloaded());
            } else {
                listener.getLogger().println(Messages.AzureStorageBuilder_files_downloaded_count(filesDownloaded));
            }
        }
        catch (WAStorageException | IOException | InterruptedException e) {
            e.printStackTrace(listener.error(Messages.AzureStorageBuilder_download_err(storageAccountInfo.getStorageAccName())));
            run.setResult(Result.UNSTABLE);
        }
    }

    private StoragePluginService<DownloadServiceData> getDownloadService(DownloadServiceData data) {
        switch (this.getDownloadType()) {
            case "share": {
                return new DownloadFromFileService(data);
            }
            case "project": {
                return new DownloadFromBuildService(data);
            }
        }
        return new DownloadFromContainerService(data);
    }

    private void validateData(Run<?, ?> run, TaskListener listener, StorageAccountInfo storageAccountInfo) {
        if (run.getResult() == Result.FAILURE) {
            listener.getLogger().println(Messages.AzureStorageBuilder_build_failed_err());
        }
        if (storageAccountInfo == null) {
            listener.getLogger().println(Messages.WAStoragePublisher_storage_account_err());
            run.setResult(Result.UNSTABLE);
        }
        try {
            AzureUtils.validateStorageAccount(storageAccountInfo, true);
        }
        catch (Exception e) {
            listener.getLogger().println(Messages.Client_SA_val_fail());
            listener.getLogger().println(storageAccountInfo.getStorageAccName());
            listener.getLogger().println(storageAccountInfo.getBlobEndPointURL());
            listener.getLogger().println(storageAccountInfo.getCdnEndPointURL());
            run.setResult(Result.UNSTABLE);
        }
    }

    public AzureStorageBuilderDesc getDescriptor() {
        return (AzureStorageBuilderDesc)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"azureDownload"})
    public static final class AzureStorageBuilderDesc
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public AzureStorageBuilderDesc() {
            this.load();
        }

        public ListBoxModel doFillStorageAccNameItems() {
            ListBoxModel m = new ListBoxModel();
            StorageAccountInfo[] storageAccounts = this.getStorageAccounts();
            if (storageAccounts != null) {
                for (StorageAccountInfo storageAccount : storageAccounts) {
                    m.add(storageAccount.getStorageAccName());
                }
            }
            return m;
        }

        public ListBoxModel doFillStorageCredentialIdItems(@AncestorInPath Item owner) {
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentialsInItem(AzureStorageAccount.class, (Item)owner, (Authentication)ACL.SYSTEM2, Collections.emptyList()));
        }

        public AutoCompletionCandidates doAutoCompleteProjectName(@QueryParameter String value) {
            AutoCompletionCandidates projectList = new AutoCompletionCandidates();
            for (AbstractProject project : Jenkins.get().getItems(AbstractProject.class)) {
                if (!project.getName().toLowerCase().startsWith(value.toLowerCase())) continue;
                projectList.add(project.getName());
            }
            return projectList;
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return Messages.AzureStorageBuilder_displayName();
        }

        public StorageAccountInfo[] getStorageAccounts() {
            WAStoragePublisher.WAStorageDescriptor publisherDescriptor = (WAStoragePublisher.WAStorageDescriptor)Jenkins.get().getDescriptorByType(WAStoragePublisher.WAStorageDescriptor.class);
            return publisherDescriptor.getStorageAccounts();
        }

        public StorageAccountInfo getStorageAccount(String storageAccountName) {
            if (storageAccountName == null || storageAccountName.trim().length() == 0) {
                return null;
            }
            StorageAccountInfo storageAcc = null;
            StorageAccountInfo[] storageAccounts = this.getStorageAccounts();
            if (storageAccounts != null) {
                for (StorageAccountInfo sa : storageAccounts) {
                    if (!sa.getStorageAccName().equals(storageAccountName)) continue;
                    storageAcc = sa;
                    storageAcc.setBlobEndPointURL(Utils.getBlobEP(storageAcc.getBlobEndPointURL()));
                    break;
                }
            }
            return storageAcc;
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getAvailableBuildSelectorList() {
            return DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.getInstance(), BuildSelector.class);
        }
    }
}

